/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum SoundPortEnum implements BidibEnum
{
    PLAY(1),
    STOP(0),
    TEST(ByteUtils.getLowByte(255));

    private final byte type;

    private SoundPortEnum(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static SoundPortEnum valueOf(int type) {
        return SoundPortEnum.valueOf(ByteUtils.getLowByte(type));
    }

    public static SoundPortEnum valueOf(byte type) {
        SoundPortEnum result = null;
        for (SoundPortEnum e : SoundPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a sound port enum");
        }
        return result;
    }
}

