/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum SwitchPortEnum implements BidibEnum
{
    ON(1),
    OFF(0),
    TEST(ByteUtils.getLowByte(255));

    private final byte type;

    private SwitchPortEnum(int type) {
        this.type = (byte)type;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static SwitchPortEnum valueOf(int type) {
        return SwitchPortEnum.valueOf(ByteUtils.getLowByte(type));
    }

    public static SwitchPortEnum valueOf(byte type) {
        SwitchPortEnum result = null;
        for (SwitchPortEnum e : SwitchPortEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a switch port enum");
        }
        return result;
    }
}

