/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum SysErrorEnum implements BidibEnum
{
    BIDIB_ERR_NONE(0),
    BIDIB_ERR_TXT(1),
    BIDIB_ERR_CRC(2),
    BIDIB_ERR_SIZE(3),
    BIDIB_ERR_SEQUENCE(4),
    BIDIB_ERR_PARAMETER(5),
    BIDIB_ERR_BUS(16),
    BIDIB_ERR_ADDRSTACK(17),
    BIDIB_ERR_IDDOUBLE(18),
    BIDIB_ERR_SUBCRC(19),
    BIDIB_ERR_SUBTIME(20),
    BIDIB_ERR_SUBPAKET(21),
    BIDIB_ERR_OVERRUN(22),
    BIDIB_ERR_HW(32),
    BIDIB_ERR_RESET_REQUIRED(33),
    BIDIB_ERR_NO_SECACK_BY_HOST(48);

    private final byte type;

    private SysErrorEnum(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static SysErrorEnum valueOf(byte type) {
        SysErrorEnum result = null;
        for (SysErrorEnum e : SysErrorEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("Cannot map " + type + " to an sys error.");
        }
        return result;
    }
}

