/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum TargetModeEnum implements BidibEnum
{
    BIDIB_TARGET_MODE_UID(0),
    BIDIB_TARGET_MODE_ALL(1),
    BIDIB_TARGET_MODE_HUB(15),
    BIDIB_TARGET_MODE_SWITCH(8),
    BIDIB_TARGET_MODE_BOOSTER(9),
    BIDIB_TARGET_MODE_ACCESSORY(10),
    BIDIB_TARGET_MODE_DCCGEN(12),
    BIDIB_TARGET_MODE_TOP(2);

    private final byte type;

    private TargetModeEnum(int type) {
        this.type = ByteUtils.getLowByte(type);
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static TargetModeEnum valueOf(byte type) {
        TargetModeEnum result = null;
        for (TargetModeEnum e : TargetModeEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a target mode enum");
        }
        return result;
    }
}

