/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum TimeBaseUnitEnum implements BidibEnum
{
    UNIT_100MS("unit-100ms", 0),
    UNIT_1S("unit-1s", 1);

    private final String key;
    private final byte type;

    private TimeBaseUnitEnum(String key, int type) {
        this.key = key;
        this.type = (byte)type;
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static TimeBaseUnitEnum valueOf(byte type) {
        TimeBaseUnitEnum result = null;
        for (TimeBaseUnitEnum e : TimeBaseUnitEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a time base unit enum");
        }
        return result;
    }

    public static TimeBaseUnitEnum valueOf(int value) {
        TimeBaseUnitEnum result = null;
        byte type = ByteUtils.getLowByte(value);
        for (TimeBaseUnitEnum e : TimeBaseUnitEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a time base unit enum");
        }
        return result;
    }
}

