/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.enums;

import org.bidib.jbidibc.messages.enums.BidibEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public enum TimingControlEnum implements BidibEnum
{
    COIL_ON_OFF("coil-on-off", 0),
    OUTPUT_UNIT("output-unit", 1);

    private final String key;
    private final byte type;

    private TimingControlEnum(String key, int type) {
        this.key = key;
        this.type = ByteUtils.getLowByte(type);
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public static TimingControlEnum valueOf(byte type) {
        TimingControlEnum result = null;
        for (TimingControlEnum e : TimingControlEnum.values()) {
            if (e.type != type) continue;
            result = e;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("cannot map " + type + " to a timing control enum");
        }
        return result;
    }
}

