/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.exception;

import org.bidib.jbidibc.messages.exception.ReasonAware;

public class PortNotOpenedException
extends Exception
implements ReasonAware {
    private static final long serialVersionUID = 1L;
    public static final String PORT_IN_USE = "portInUse";
    public static final String UNKNOWN = "unknown";
    public static final String PORT_NOT_FOUND = "portNotFound";
    public static final String CONNECT_FAILED = "connectFailed";
    public static final String ESTABLISH_COMMUNICATION_FAILED = "establishCommunicationFailed";
    private String reason;
    private FailureReason failureReason;

    public PortNotOpenedException() {
        this.reason = UNKNOWN;
    }

    public PortNotOpenedException(String message, String reason) {
        super(message);
        this.reason = reason;
    }

    public PortNotOpenedException(String message, Throwable cause) {
        super(message, cause);
        this.reason = UNKNOWN;
    }

    @Override
    public String getReason() {
        if (this.reason == null) {
            return UNKNOWN;
        }
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setFailureReason(FailureReason failureReason) {
        this.failureReason = failureReason;
    }

    public FailureReason getFailureReason() {
        return this.failureReason;
    }

    public PortNotOpenedException withFailureReason(FailureReason failureReason) {
        this.failureReason = failureReason;
        return this;
    }

    public static enum FailureReason {
        PORT_IN_USE("portInUse"),
        PORT_NOT_FOUND("portNotFound"),
        CONNECT_FAILED("connectFailed"),
        ESTABLISH_COMMUNICATION_FAILED("establishCommunicationFailed"),
        UNKNOWN("unknown");

        private String key;

        private FailureReason(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

