/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.helpers;

import java.util.LinkedHashMap;
import java.util.Map;
import org.bidib.jbidibc.messages.helpers.Context;

public class DefaultContext
implements Context {
    private Map<String, Object> registry = new LinkedHashMap<String, Object>();

    @Override
    public Object register(String key, Object content) {
        return this.registry.put(key, content);
    }

    @Override
    public Object unregister(String key) {
        return this.registry.remove(key);
    }

    @Override
    public Object get(String key) {
        return this.registry.get(key);
    }

    @Override
    public <T, R> R get(String key, Class<T> type, T defaultValue) {
        T value = this.get(type, this.get(key));
        if (value == null) {
            return (R)defaultValue;
        }
        return (R)value;
    }

    protected <T> T get(Class<T> type, Object body) {
        if (type.isInstance(body)) {
            return type.cast(body);
        }
        return null;
    }

    @Override
    public void mergeIntoMap(Map<String, Object> map) {
        map.putAll(this.registry);
    }

    @Override
    public void mergeFromMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultContext[");
        boolean multiple = false;
        for (Map.Entry<String, Object> entry : this.registry.entrySet()) {
            if (multiple) {
                sb.append(", ");
            }
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            multiple = true;
        }
        return sb.append("]").toString();
    }
}

