/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibGuestMessage;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.message.ProtocolSupplier;

public abstract class AbstractBidibGuestMessage
extends BidibCommandMessage
implements BidibGuestMessage {
    private TargetModeEnum targetMode;
    private byte[] targetModeUniqueId;
    protected final int[] indexHolder = new int[1];

    protected AbstractBidibGuestMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int type, ProtocolSupplier<byte[]> dataSupplier) throws ProtocolException {
        super(addr, num, type, dataSupplier);
        this.targetMode = targetMode;
        this.targetModeUniqueId = targetModeUniqueId;
    }

    public AbstractBidibGuestMessage(byte[] message) throws ProtocolException {
        super(message);
        this.targetMode = TargetModeEnum.valueOf(this.getData()[0]);
        if (this.targetMode == TargetModeEnum.BIDIB_TARGET_MODE_UID) {
            this.targetModeUniqueId = this.extractTargetModeUniqueId();
        }
        this.indexHolder[0] = (this.targetModeUniqueId != null ? this.targetModeUniqueId.length : 0) + 1;
    }

    protected byte[] extractTargetModeUniqueId() throws ProtocolException {
        ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
        BidibMessage.extractTargetModeUniqueId(this.getData(), 1, this.targetMode, dataBytes);
        return dataBytes.toByteArray();
    }

    @Override
    public TargetModeEnum getTargetMode() {
        return this.targetMode;
    }

    protected byte[] getTargetModeUniqueIdIgnoreMode() {
        return this.targetModeUniqueId;
    }

    @Override
    public byte[] getTargetUniqueId() throws ProtocolException {
        switch (this.getTargetMode()) {
            case BIDIB_TARGET_MODE_UID: {
                return this.targetModeUniqueId;
            }
            case BIDIB_TARGET_MODE_ALL: 
            case BIDIB_TARGET_MODE_TOP: 
            case BIDIB_TARGET_MODE_SWITCH: 
            case BIDIB_TARGET_MODE_BOOSTER: 
            case BIDIB_TARGET_MODE_ACCESSORY: 
            case BIDIB_TARGET_MODE_DCCGEN: {
                return null;
            }
        }
        throw new ProtocolException("Get uniqueId is not supported in targetMode: {}" + this.getTargetMode());
    }

    protected static void appendTargetModeUniqueId(ByteArrayOutputStream baos, byte[] targetModeUniqueId) throws ProtocolException {
        if (targetModeUniqueId != null) {
            try {
                baos.write(targetModeUniqueId);
            }
            catch (IOException ex) {
                throw new ProtocolException("Add uniqueId to message data failed.");
            }
        }
    }
}

