/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class AccessoryNotifyResponse
extends BidibMessage {
    public static final Integer TYPE = 186;

    AccessoryNotifyResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 5) {
            throw new ProtocolException("No valid MSG_ACCESSORY_NOTIFY received");
        }
    }

    public AccessoryNotifyResponse(byte[] addr, int num, byte accessoryNum, byte aspect, byte[] value) throws ProtocolException {
        this(addr, num, 186, ByteUtils.concat(new byte[]{accessoryNum, aspect}, value));
    }

    public AccessoryNotifyResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 5) {
            throw new ProtocolException("No valid MSG_ACCESSORY_NOTIFY received");
        }
    }

    @Override
    public String getName() {
        return "MSG_ACCESSORY_NOTIFY";
    }

    public AccessoryState getAccessoryState() {
        byte[] data = this.getData();
        return new AccessoryState(data[0], data[1], data[2], data[3], data[4]);
    }

    public AccessoryStateOptions getAccessoryStateOptions() {
        if (this.getData().length > 5) {
            return new AccessoryStateOptions(this.getData(), 5);
        }
        return null;
    }

    public String toExtendedString() {
        StringBuilder sb = new StringBuilder("[ ");
        sb.append(super.toString());
        byte[] data = this.getData();
        sb.append(", num: ").append(ByteUtils.getInt(data[0]));
        sb.append(", aspect: ").append(ByteUtils.getInt(data[1]));
        sb.append(", total: ").append(ByteUtils.getInt(data[2]));
        sb.append(", execute: ").append(ByteUtils.getInt(data[3]));
        if ((data[3] & 0x80) == 128) {
            sb.append(" => Error detected.");
        } else {
            switch (data[3] & 1) {
                case 0: {
                    sb.append(" => Reached end position.");
                    break;
                }
                case 1: {
                    sb.append(" => End position not yet reached. Check WAIT.");
                    break;
                }
                default: {
                    sb.append(" => Unknown.");
                }
            }
            switch (data[3] & 2) {
                case 0: {
                    sb.append(" => End position is verified by feedback.");
                    break;
                }
                case 2: {
                    sb.append(" => No control of end position possible.");
                    break;
                }
                default: {
                    sb.append(" => Unknown.");
                }
            }
        }
        int remainingTime = 0;
        switch (data[4] & 0x80) {
            case 0: {
                remainingTime = (data[4] & 0x7F) * 100;
                break;
            }
            default: {
                remainingTime = (data[4] & 0x7F) * 1000;
            }
        }
        sb.append(", remaing wait time: ").append(remainingTime).append("ms");
        return sb.toString();
    }
}

