/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class AccessoryParaResponse
extends BidibMessage {
    public static final Integer TYPE = 185;
    public static final byte UNKNOWN_PARA = ByteUtils.getLowByte(255);

    AccessoryParaResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_ACCESSORY_PARA received");
        }
    }

    public AccessoryParaResponse(byte[] addr, int num, int accessoryNum, int paraNum, int[] value) throws ProtocolException {
        this(addr, num, 185, ByteUtils.concat(new byte[]{ByteUtils.getLowByte(accessoryNum), ByteUtils.getLowByte(paraNum)}, ByteUtils.toArray(value)));
    }

    public AccessoryParaResponse(byte[] addr, int num, byte accessoryNum, byte paraNum, byte[] value) throws ProtocolException {
        this(addr, num, 185, ByteUtils.concat(new byte[]{accessoryNum, paraNum}, value));
    }

    public AccessoryParaResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_ACCESSORY_PARA received");
        }
    }

    @Override
    public String getName() {
        return "MSG_ACCESSORY_PARA";
    }

    public int getAccessoryNumber() {
        return this.getData()[0];
    }

    public int getParameter() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public byte[] getValue() {
        byte[] data = this.getData();
        if (data.length > 2) {
            byte[] result = new byte[data.length - 2];
            System.arraycopy(data, 2, result, 0, result.length);
            return result;
        }
        return null;
    }
}

