/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class AccessoryParaSetMessage
extends BidibCommandMessage {
    public static final Integer TYPE = 58;

    public AccessoryParaSetMessage(int accessoryNumber, int parameter, byte[] value) {
        super(0, 58, ByteUtils.concat(new byte[]{(byte)accessoryNumber, (byte)parameter}, value));
    }

    public AccessoryParaSetMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_ACCESSORY_PARA_SET";
    }

    public int getAccessoryNumber() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public int getParaNumber() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public byte[] getValue() {
        byte[] data = this.getData();
        byte[] result = new byte[data.length - 2];
        System.arraycopy(data, 2, result, 0, result.length);
        return result;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{AccessoryParaResponse.TYPE};
    }
}

