/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AccessoryState;
import org.bidib.jbidibc.messages.AccessoryStateOptions;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class AccessoryStateResponse
extends BidibMessage {
    public static final Integer TYPE = 184;

    AccessoryStateResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 5) {
            throw new ProtocolException("No valid MSG_ACCESSORY_STATE received");
        }
    }

    public AccessoryStateResponse(byte[] addr, int num, int accessoryNum, int aspect, byte[] value) throws ProtocolException {
        this(addr, num, ByteUtils.getLowByte(accessoryNum), ByteUtils.getLowByte(aspect), value);
    }

    public AccessoryStateResponse(byte[] addr, int num, byte accessoryNum, byte aspect, byte[] value) throws ProtocolException {
        this(addr, num, 184, ByteUtils.concat(new byte[]{accessoryNum, aspect}, value));
    }

    public AccessoryStateResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 5) {
            throw new ProtocolException("No valid MSG_ACCESSORY_STATE received");
        }
    }

    @Override
    public String getName() {
        return "MSG_ACCESSORY_STATE";
    }

    public AccessoryState getAccessoryState() {
        byte[] data = this.getData();
        return new AccessoryState(data[0], data[1], data[2], data[3], data[4]);
    }

    public AccessoryStateOptions getAccessoryStateOptions() {
        if (this.getData().length > 5) {
            return new AccessoryStateOptions(this.getData(), 5);
        }
        return null;
    }

    public String toExtendedString() {
        StringBuilder sb = new StringBuilder("[ ");
        sb.append(super.toString());
        byte[] data = this.getData();
        boolean errorDetected = false;
        sb.append(", num: ").append(ByteUtils.getInt(data[0]));
        sb.append(", aspect: ").append(ByteUtils.getInt(data[1]));
        sb.append(", total: ").append(ByteUtils.getInt(data[2]));
        sb.append(", execute: ").append(ByteUtils.getInt(data[3]));
        if ((data[3] & 0x80) == 128) {
            sb.append(" => Error detected.");
            errorDetected = true;
        } else {
            switch (data[3] & 1) {
                case 0: {
                    sb.append(" => Reached end position.");
                    break;
                }
                case 1: {
                    sb.append(" => End position not yet reached. Check WAIT.");
                    break;
                }
                default: {
                    sb.append(" => Unknown.");
                }
            }
            switch (data[3] & 2) {
                case 0: {
                    sb.append(" => End position is verified by feedback.");
                    break;
                }
                case 2: {
                    sb.append(" => No control of end position possible.");
                    break;
                }
                default: {
                    sb.append(" => Unknown.");
                }
            }
        }
        if (!errorDetected) {
            int remainingTime = 0;
            int timeVal = ByteUtils.getInt(data[4]);
            switch (timeVal & 0x80) {
                case 0: {
                    remainingTime = (timeVal & 0x7F) * 100;
                    break;
                }
                default: {
                    remainingTime = (timeVal & 0x7F) * 1000;
                }
            }
            sb.append(", remaing wait time: ").append(remainingTime).append("ms");
        } else {
            int errorVal = ByteUtils.getInt(data[4]);
            boolean moreErrorsAvailable = (errorVal & 0x40) == 64;
            sb.append(", more errors pending: ").append(moreErrorsAvailable).append(", error: ");
            switch (errorVal & 0x1F) {
                case 0: {
                    sb.append("no error (remaining)");
                    break;
                }
                case 1: {
                    sb.append("command was not executable / unknown command / unknown aspect.");
                    break;
                }
                case 2: {
                    sb.append("power consumption too high.");
                    break;
                }
                case 3: {
                    sb.append("power supply below limits, function not garanteed.");
                    break;
                }
                case 4: {
                    sb.append("fuse blown.");
                    break;
                }
                case 5: {
                    sb.append("temperature too high.");
                    break;
                }
                case 6: {
                    sb.append("feedback error / unwanted change of position.");
                    break;
                }
                case 7: {
                    sb.append("manual control (eg. with local button)");
                    break;
                }
                case 8: {
                    sb.append("bulb out of order.");
                    break;
                }
                case 9: {
                    sb.append("servo out of order.");
                    break;
                }
                case 63: {
                    sb.append("internal error (eg. selftest, checksum error, ..).");
                    break;
                }
                default: {
                    sb.append("Unknown error: ").append(ByteUtils.byteToHex(errorVal));
                }
            }
        }
        return sb.toString();
    }
}

