/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.ProtocolSupplier;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class BidibMessage
implements BidibMessageInterface {
    private byte[] addr;
    private int num;
    private byte type;
    private byte[] data;

    protected BidibMessage(byte[] addr, int num, int type, byte ... data) {
        this.addr = addr != null ? (byte[])addr.clone() : null;
        this.num = num & 0xFF;
        this.type = (byte)(type & 0xFF);
        this.data = data;
    }

    protected BidibMessage(int num, int type, byte ... data) {
        this.num = num & 0xFF;
        this.type = (byte)(type & 0xFF);
        this.data = data;
    }

    protected BidibMessage(byte[] addr, int num, int type, ProtocolSupplier<byte[]> dataSupplier) throws ProtocolException {
        this(addr, num, type, dataSupplier.get());
    }

    protected BidibMessage(byte[] message) throws ProtocolException {
        if (message == null || message.length <= 1) {
            throw new ProtocolException("message too short");
        }
        int index = 0;
        byte length = message[index++];
        ByteArrayOutputStream dataBytes = new ByteArrayOutputStream();
        index = BidibMessage.extractAddress(message, index, dataBytes);
        this.addr = dataBytes.toByteArray();
        this.num = ByteUtils.getInt(message[index++]);
        this.type = message[index++];
        dataBytes.reset();
        dataBytes.write(message, index, length - index + 1);
        this.data = dataBytes.toByteArray();
        this.verify();
    }

    protected void verify() throws ProtocolException {
    }

    public static int extractAddress(byte[] message, int index, ByteArrayOutputStream dataBytes) throws ProtocolException {
        while (message[index] != 0) {
            dataBytes.write(message[index++]);
            if (index < message.length) continue;
            throw new ProtocolException("Invalid message. Reason: address too long. Current message: " + ByteUtils.bytesToHex(message));
        }
        if (dataBytes.size() == 0) {
            dataBytes.write(0);
        }
        return ++index;
    }

    public static int extractTargetModeUniqueId(byte[] message, int index, TargetModeEnum targetMode, ByteArrayOutputStream dataBytes) throws ProtocolException {
        switch (targetMode) {
            case BIDIB_TARGET_MODE_UID: {
                if (index + 5 >= message.length) {
                    throw new ProtocolException("Invalid message. Reason: The uniqueId is not of expected size. Current message: " + ByteUtils.bytesToHex(message));
                }
                try {
                    dataBytes.write(ByteUtils.subArray(message, index, 5));
                }
                catch (IOException ex) {
                    throw new ProtocolException("Invalid message. Reason: Copy uniqueID failed. Current message: " + ByteUtils.bytesToHex(message));
                }
                index += 5;
                break;
            }
            case BIDIB_TARGET_MODE_SWITCH: 
            case BIDIB_TARGET_MODE_BOOSTER: 
            case BIDIB_TARGET_MODE_ACCESSORY: 
            case BIDIB_TARGET_MODE_DCCGEN: {
                break;
            }
            case BIDIB_TARGET_MODE_TOP: 
            case BIDIB_TARGET_MODE_ALL: {
                break;
            }
            default: {
                throw new ProtocolException("Unsupported target mode detetced: " + targetMode);
            }
        }
        return index;
    }

    public static int getMessageType(byte[] message) throws ProtocolException {
        if (message != null && message.length > 1) {
            int index = 0;
            ++index;
            while (message[index] != 0) {
                if (++index < message.length) continue;
                throw new ProtocolException("Invalid message. Reason: address too long. Current message: " + ByteUtils.bytesToHex(message));
            }
            ++index;
            int type = ByteUtils.getInt(message[++index]);
            return type;
        }
        throw new ProtocolException("message too short");
    }

    @Override
    public void setAddr(byte[] addr) {
        this.addr = addr;
    }

    @Override
    public byte[] getAddr() {
        return this.addr;
    }

    @Override
    public int getNum() {
        return this.num;
    }

    @Override
    public void setSendMsgNum(int sendMsgNum) {
        this.num = sendMsgNum;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    protected void appendToStringDescriptor(StringBuilder sb) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        this.appendToStringDescriptor(sb);
        sb.append("[");
        if (this.addr != null) {
            sb.append(ByteUtils.toString(this.addr)).append(",");
        }
        sb.append("num=").append(this.num & 0xFF).append(",type=").append(this.type & 0xFF).append(",data=").append(ByteUtils.bytesToHex(this.data)).append("]");
        return sb.toString();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean equals(Object obj) {
        BidibMessage other;
        if (obj instanceof BidibMessage && (other = (BidibMessage)obj).getType() == this.getType() && other.getNum() == this.getNum() && Arrays.equals(other.getAddr(), this.getAddr()) && Arrays.equals(other.getData(), this.getData())) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Arrays.hashCode(this.addr) + this.num + (this.type & 0xFF) + Arrays.hashCode(this.data);
    }

    @Override
    public byte[] getContent() {
        int size = 1 + this.addr.length + 1 + 1 + 1 + this.data.length;
        boolean rootAddr = false;
        if (this.addr.length == 1 && this.addr[0] == 0) {
            size = 1 + this.addr.length + 1 + 1 + this.data.length;
            rootAddr = true;
        }
        byte[] content = new byte[size];
        int index = 0;
        content[index++] = ByteUtils.getLowByte(size - 1);
        System.arraycopy(this.addr, 0, content, index, this.addr.length);
        index += this.addr.length;
        if (!rootAddr) {
            content[index++] = 0;
        }
        content[index++] = ByteUtils.getLowByte(this.num);
        content[index++] = this.type;
        System.arraycopy(this.data, 0, content, index, this.data.length);
        return content;
    }

    @Override
    public byte[] getMessageContent() {
        int size = 1 + this.data.length;
        byte[] content = new byte[size];
        int index = 0;
        content[index++] = this.type;
        System.arraycopy(this.data, 0, content, index, this.data.length);
        return content;
    }
}

