/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfig;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.config.MessageType;
import org.bidib.jbidibc.messages.enums.ActivateCoilEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.enums.FirmwareUpdateOperation;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.LcMacroOperationCode;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.NetBidibRole;
import org.bidib.jbidibc.messages.enums.OccupationState;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.enums.TargetModeEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryGetAllMessage;
import org.bidib.jbidibc.messages.message.AccessoryGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryNotifyResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaGetMessage;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaSetMessage;
import org.bidib.jbidibc.messages.message.AccessorySetMessage;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibCommand;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BoostDiagnosticResponse;
import org.bidib.jbidibc.messages.message.BoostOffMessage;
import org.bidib.jbidibc.messages.message.BoostOnMessage;
import org.bidib.jbidibc.messages.message.BoostQueryMessage;
import org.bidib.jbidibc.messages.message.BoostStatResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryMessage;
import org.bidib.jbidibc.messages.message.CommandStationBinaryStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveEventResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationM4AcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationM4Message;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgMessage;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationQueryMessage;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusMessage;
import org.bidib.jbidibc.messages.message.CommandStationSetStateMessage;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeatureCountResponse;
import org.bidib.jbidibc.messages.message.FeatureGetAllMessage;
import org.bidib.jbidibc.messages.message.FeatureGetMessage;
import org.bidib.jbidibc.messages.message.FeatureGetNextMessage;
import org.bidib.jbidibc.messages.message.FeatureNotAvailableResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeatureSetMessage;
import org.bidib.jbidibc.messages.message.FeedbackAccessoryResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackCurrentResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackDccAResponse;
import org.bidib.jbidibc.messages.message.FeedbackDynStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackGetAddressRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetConfidenceMessage;
import org.bidib.jbidibc.messages.message.FeedbackGetRangeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorFreeMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorMultipleMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorOccupiedMessage;
import org.bidib.jbidibc.messages.message.FeedbackMirrorPositionMessage;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackPositionResponse;
import org.bidib.jbidibc.messages.message.FeedbackRcPlusResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.message.FeedbackXPomResponse;
import org.bidib.jbidibc.messages.message.FwUpdateOpMessage;
import org.bidib.jbidibc.messages.message.FwUpdateStatResponse;
import org.bidib.jbidibc.messages.message.GetPacketCapacityMessage;
import org.bidib.jbidibc.messages.message.GuestRequestSendMessage;
import org.bidib.jbidibc.messages.message.GuestRequestSubscribeMessage;
import org.bidib.jbidibc.messages.message.GuestRequestUnsubscribeMessage;
import org.bidib.jbidibc.messages.message.GuestResponseNotifyMessage;
import org.bidib.jbidibc.messages.message.GuestResponseSentMessage;
import org.bidib.jbidibc.messages.message.GuestResponseSubscriptionCountMessage;
import org.bidib.jbidibc.messages.message.GuestResponseSubscriptionMessage;
import org.bidib.jbidibc.messages.message.LcConfigGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigSetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetAllMessage;
import org.bidib.jbidibc.messages.message.LcConfigXGetMessage;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcConfigXSetMessage;
import org.bidib.jbidibc.messages.message.LcKeyMessage;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroHandleMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaGetMessage;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroSetMessage;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcOutputMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryAllMessage;
import org.bidib.jbidibc.messages.message.LcPortQueryMessage;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.message.LcWaitResponse;
import org.bidib.jbidibc.messages.message.LocalAnnounceMessage;
import org.bidib.jbidibc.messages.message.LocalBidibDownMessage;
import org.bidib.jbidibc.messages.message.LocalBidibUpResponse;
import org.bidib.jbidibc.messages.message.LocalDiscoverMessage;
import org.bidib.jbidibc.messages.message.LocalEmitterMessage;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.LocalLogonRejectedMessage;
import org.bidib.jbidibc.messages.message.LocalPingMessage;
import org.bidib.jbidibc.messages.message.LocalPongResponse;
import org.bidib.jbidibc.messages.message.LocalSyncMessage;
import org.bidib.jbidibc.messages.message.NodeChangedAckMessage;
import org.bidib.jbidibc.messages.message.NodeLostResponse;
import org.bidib.jbidibc.messages.message.NodeNewResponse;
import org.bidib.jbidibc.messages.message.NodeNotAvailableResponse;
import org.bidib.jbidibc.messages.message.NodeTabCountResponse;
import org.bidib.jbidibc.messages.message.NodeTabGetAllMessage;
import org.bidib.jbidibc.messages.message.NodeTabGetNextMessage;
import org.bidib.jbidibc.messages.message.NodeTabResponse;
import org.bidib.jbidibc.messages.message.PacketCapacityResponse;
import org.bidib.jbidibc.messages.message.RequestFactory;
import org.bidib.jbidibc.messages.message.StallResponse;
import org.bidib.jbidibc.messages.message.StringGetMessage;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.StringSetMessage;
import org.bidib.jbidibc.messages.message.SysClockMessage;
import org.bidib.jbidibc.messages.message.SysDisableMessage;
import org.bidib.jbidibc.messages.message.SysEnableMessage;
import org.bidib.jbidibc.messages.message.SysErrorResponse;
import org.bidib.jbidibc.messages.message.SysGetErrorMessage;
import org.bidib.jbidibc.messages.message.SysGetMagicMessage;
import org.bidib.jbidibc.messages.message.SysGetPVersionMessage;
import org.bidib.jbidibc.messages.message.SysGetSwVersionMessage;
import org.bidib.jbidibc.messages.message.SysGetUniqueIdMessage;
import org.bidib.jbidibc.messages.message.SysIdentifyMessage;
import org.bidib.jbidibc.messages.message.SysIdentifyStateResponse;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysPingMessage;
import org.bidib.jbidibc.messages.message.SysPongResponse;
import org.bidib.jbidibc.messages.message.SysResetMessage;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.SysUniqueIdResponse;
import org.bidib.jbidibc.messages.message.UnknownCommandMessage;
import org.bidib.jbidibc.messages.message.VendorAckResponse;
import org.bidib.jbidibc.messages.message.VendorDisableMessage;
import org.bidib.jbidibc.messages.message.VendorEnableMessage;
import org.bidib.jbidibc.messages.message.VendorGetMessage;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.message.VendorSetMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.message.netbidib.NetBidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;

public class BidibRequestFactory
implements RequestFactory {
    protected Map<Integer, MessageType> messageTypeMap = new LinkedHashMap<Integer, MessageType>();
    private boolean escapeMagic = true;

    @Override
    public void initialize() {
    }

    @Override
    public void setEscapeMagic(boolean escapeMagic) {
        this.escapeMagic = escapeMagic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageTypes(List<MessageType> messageTypes) {
        Map<Integer, MessageType> map = this.messageTypeMap;
        synchronized (map) {
            this.messageTypeMap.clear();
            for (MessageType messageType : messageTypes) {
                this.messageTypeMap.put(messageType.getId(), messageType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMessageTypesLoaded() {
        Map<Integer, MessageType> map = this.messageTypeMap;
        synchronized (map) {
            return !this.messageTypeMap.isEmpty();
        }
    }

    @Override
    public List<BidibMessageInterface> create(byte[] messageData) throws ProtocolException {
        this.logDebugMessage("Create bidib message from raw messageData: {}", new Object[]{messageData});
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ArrayList<BidibMessageInterface> bidibMessages = new ArrayList<BidibMessageInterface>();
        if (this.escapeMagic) {
            boolean escapeHot = false;
            StringBuilder logRecord = new StringBuilder();
            for (byte data : messageData) {
                logRecord.append(ByteUtils.byteToHex(data)).append(" ");
                if (data == ByteUtils.getLowByte(254) && output.size() > 0) {
                    this.logDebugMessage("Received raw message: {}", logRecord);
                    this.logRawMessage("<< {}", logRecord);
                    logRecord.setLength(0);
                    byte[] messageContent = output.toByteArray();
                    this.createFromRaw(messageContent, bidibMessages);
                    output.reset();
                    break;
                }
                if (data == ByteUtils.getLowByte(253)) {
                    escapeHot = true;
                    continue;
                }
                if (data == ByteUtils.getLowByte(254)) continue;
                if (escapeHot) {
                    data = (byte)(data ^ 0x20);
                    escapeHot = false;
                }
                output.write(data);
            }
        } else {
            this.createFromRaw(messageData, bidibMessages);
        }
        return bidibMessages;
    }

    protected void logDebugMessage(String message, Object ... args) {
    }

    protected void logWarnMessage(String message, Object ... args) {
    }

    protected void logRawMessage(String message, StringBuilder logRecord) {
    }

    public void createFromRaw(byte[] messageContent, List<BidibMessageInterface> bidibMessages) throws ProtocolException {
        byte len = messageContent[0];
        if (len + 1 < messageContent.length - 1) {
            for (int index = 0; index < messageContent.length - 1; index += len + 1) {
                len = messageContent[index];
                byte[] part = new byte[len + 1];
                System.arraycopy(messageContent, index, part, 0, len + 1);
                BidibMessageInterface bidibMessage = this.createConcreteMessage(part);
                bidibMessages.add(bidibMessage);
            }
        } else {
            BidibMessageInterface bidibMessage = this.createConcreteMessage(messageContent);
            bidibMessages.add(bidibMessage);
        }
    }

    @Override
    public BidibMessageInterface createRaw(byte[] message) throws ProtocolException {
        BidibMessage result = new BidibMessage(message);
        return result;
    }

    @Override
    public BidibMessageInterface createConcreteMessage(byte[] message) throws ProtocolException {
        BidibMessage concreteBidibMessage = null;
        int type = BidibMessage.getMessageType(message);
        switch (type) {
            case 1: {
                concreteBidibMessage = new SysGetMagicMessage(message);
                break;
            }
            case 14: {
                concreteBidibMessage = new SysGetErrorMessage(message);
                break;
            }
            case 5: {
                concreteBidibMessage = new SysGetUniqueIdMessage(message);
                break;
            }
            case 24: {
                concreteBidibMessage = new SysClockMessage(message);
                break;
            }
            case 2: {
                concreteBidibMessage = new SysGetPVersionMessage(message);
                break;
            }
            case 6: {
                concreteBidibMessage = new SysGetSwVersionMessage(message);
                break;
            }
            case 3: {
                concreteBidibMessage = new SysEnableMessage(message);
                break;
            }
            case 4: {
                concreteBidibMessage = new SysDisableMessage(message);
                break;
            }
            case 8: {
                concreteBidibMessage = new SysIdentifyMessage(message);
                break;
            }
            case 7: {
                concreteBidibMessage = new SysPingMessage(message);
                break;
            }
            case 9: {
                concreteBidibMessage = new SysResetMessage(message);
                break;
            }
            case 129: {
                concreteBidibMessage = new SysMagicResponse(message);
                break;
            }
            case 134: {
                concreteBidibMessage = new SysErrorResponse(message);
                break;
            }
            case 135: {
                concreteBidibMessage = new SysIdentifyStateResponse(message);
                break;
            }
            case 130: {
                concreteBidibMessage = new SysPongResponse(message);
                break;
            }
            case 131: {
                concreteBidibMessage = new SysPVersionResponse(message);
                break;
            }
            case 133: {
                concreteBidibMessage = new SysSwVersionResponse(message);
                break;
            }
            case 132: {
                concreteBidibMessage = new SysUniqueIdResponse(message);
                break;
            }
            case 11: {
                concreteBidibMessage = new NodeTabGetAllMessage(message);
                break;
            }
            case 12: {
                concreteBidibMessage = new NodeTabGetNextMessage(message);
                break;
            }
            case 13: {
                concreteBidibMessage = new NodeChangedAckMessage(message);
                break;
            }
            case 137: {
                concreteBidibMessage = new NodeTabResponse(message);
                break;
            }
            case 140: {
                concreteBidibMessage = new NodeLostResponse(message);
                break;
            }
            case 139: {
                concreteBidibMessage = new NodeNotAvailableResponse(message);
                break;
            }
            case 141: {
                concreteBidibMessage = new NodeNewResponse(message);
                break;
            }
            case 136: {
                concreteBidibMessage = new NodeTabCountResponse(message);
                break;
            }
            case 15: {
                concreteBidibMessage = new FwUpdateOpMessage(message);
                break;
            }
            case 143: {
                concreteBidibMessage = new FwUpdateStatResponse(message);
                break;
            }
            case 50: {
                concreteBidibMessage = new BoostQueryMessage(message);
                break;
            }
            case 49: {
                concreteBidibMessage = new BoostOnMessage(message);
                break;
            }
            case 48: {
                concreteBidibMessage = new BoostOffMessage(message);
                break;
            }
            case 178: {
                concreteBidibMessage = new BoostDiagnosticResponse(message);
                break;
            }
            case 176: {
                concreteBidibMessage = new BoostStatResponse(message);
                break;
            }
            case 32: {
                concreteBidibMessage = new FeedbackGetRangeMessage(message);
                break;
            }
            case 33: {
                concreteBidibMessage = new FeedbackMirrorMultipleMessage(message);
                break;
            }
            case 34: {
                concreteBidibMessage = new FeedbackMirrorOccupiedMessage(message);
                break;
            }
            case 35: {
                concreteBidibMessage = new FeedbackMirrorFreeMessage(message);
                break;
            }
            case 36: {
                concreteBidibMessage = new FeedbackGetAddressRangeMessage(message);
                break;
            }
            case 37: {
                concreteBidibMessage = new FeedbackGetConfidenceMessage(message);
                break;
            }
            case 163: {
                concreteBidibMessage = new FeedbackAddressResponse(message);
                break;
            }
            case 169: {
                concreteBidibMessage = new FeedbackConfidenceResponse(message);
                break;
            }
            case 167: {
                concreteBidibMessage = new FeedbackCurrentResponse(message);
                break;
            }
            case 161: {
                concreteBidibMessage = new FeedbackFreeResponse(message);
                break;
            }
            case 162: {
                concreteBidibMessage = new FeedbackMultipleResponse(message);
                break;
            }
            case 160: {
                concreteBidibMessage = new FeedbackOccupiedResponse(message);
                break;
            }
            case 172: {
                concreteBidibMessage = new FeedbackPositionResponse(message);
                break;
            }
            case 38: {
                concreteBidibMessage = new FeedbackMirrorPositionMessage(message);
                break;
            }
            case 166: {
                concreteBidibMessage = new FeedbackSpeedResponse(message);
                break;
            }
            case 164: {
                concreteBidibMessage = new FeedbackAccessoryResponse(message);
                break;
            }
            case 165: {
                concreteBidibMessage = new FeedbackCvResponse(message);
                break;
            }
            case 168: {
                concreteBidibMessage = new FeedbackXPomResponse(message);
                break;
            }
            case 170: {
                concreteBidibMessage = new FeedbackDynStateResponse(message);
                break;
            }
            case 171: {
                concreteBidibMessage = new BidibMessage(message);
                int opCode = ByteUtils.getInt(concreteBidibMessage.getData()[1]);
                if ((opCode & 0x80) == 128) {
                    concreteBidibMessage = new FeedbackDccAResponse(message);
                    break;
                }
                concreteBidibMessage = new FeedbackRcPlusResponse(message);
                break;
            }
            case 124: {
                concreteBidibMessage = new LocalBidibDownMessage(message);
                break;
            }
            case 252: {
                concreteBidibMessage = new LocalBidibUpResponse(message);
                break;
            }
            case 240: {
                concreteBidibMessage = new LocalLogonMessage(message);
                break;
            }
            case 112: {
                concreteBidibMessage = new LocalLogonAckMessage(message);
                break;
            }
            case 242: {
                concreteBidibMessage = new LocalLogoffMessage(message);
                break;
            }
            case 114: {
                concreteBidibMessage = new LocalLogonRejectedMessage(message);
                break;
            }
            case 113: {
                concreteBidibMessage = new LocalPingMessage(message);
                break;
            }
            case 241: {
                concreteBidibMessage = new LocalPongResponse(message);
                break;
            }
            case 127: {
                concreteBidibMessage = new LocalEmitterMessage(message);
                break;
            }
            case 243: {
                concreteBidibMessage = new LocalAnnounceMessage(message);
                break;
            }
            case 117: {
                concreteBidibMessage = new LocalDiscoverMessage(message);
                break;
            }
            case 18: {
                concreteBidibMessage = new FeatureGetMessage(message);
                break;
            }
            case 19: {
                concreteBidibMessage = new FeatureSetMessage(message);
                break;
            }
            case 17: {
                concreteBidibMessage = new FeatureGetNextMessage(message);
                break;
            }
            case 16: {
                concreteBidibMessage = new FeatureGetAllMessage(message);
                break;
            }
            case 144: {
                concreteBidibMessage = new FeatureResponse(message);
                break;
            }
            case 146: {
                concreteBidibMessage = new FeatureCountResponse(message);
                break;
            }
            case 145: {
                concreteBidibMessage = new FeatureNotAvailableResponse(message);
                break;
            }
            case 25: {
                concreteBidibMessage = new StringGetMessage(message);
                break;
            }
            case 26: {
                concreteBidibMessage = new StringSetMessage(message);
                break;
            }
            case 149: {
                concreteBidibMessage = new StringResponse(message);
                break;
            }
            case 20: {
                concreteBidibMessage = new VendorEnableMessage(message);
                break;
            }
            case 21: {
                concreteBidibMessage = new VendorDisableMessage(message);
                break;
            }
            case 22: {
                concreteBidibMessage = new VendorSetMessage(message);
                break;
            }
            case 23: {
                concreteBidibMessage = new VendorGetMessage(message);
                break;
            }
            case 147: {
                concreteBidibMessage = new VendorResponse(message);
                break;
            }
            case 148: {
                concreteBidibMessage = new VendorAckResponse(message);
                break;
            }
            case 100: {
                concreteBidibMessage = new CommandStationDriveMessage(message);
                break;
            }
            case 98: {
                concreteBidibMessage = new CommandStationSetStateMessage(message);
                break;
            }
            case 106: {
                concreteBidibMessage = new CommandStationQueryMessage(message);
                break;
            }
            case 101: {
                concreteBidibMessage = new CommandStationAccessoryMessage(message);
                break;
            }
            case 103: {
                concreteBidibMessage = new CommandStationPomMessage(message);
                break;
            }
            case 111: {
                concreteBidibMessage = new CommandStationProgMessage(message);
                break;
            }
            case 104: {
                concreteBidibMessage = new CommandStationRcPlusMessage(message);
                break;
            }
            case 105: {
                concreteBidibMessage = new CommandStationM4Message(message);
                break;
            }
            case 107: {
                concreteBidibMessage = new CommandStationDccAdvMessage(message);
                break;
            }
            case 102: {
                concreteBidibMessage = new CommandStationBinaryStateMessage(message);
                break;
            }
            case 225: {
                concreteBidibMessage = new CommandStationStateResponse(message);
                break;
            }
            case 226: {
                concreteBidibMessage = new CommandStationDriveAcknowledgeResponse(message);
                break;
            }
            case 229: {
                concreteBidibMessage = new CommandStationDriveManualResponse(message);
                break;
            }
            case 230: {
                concreteBidibMessage = new CommandStationDriveEventResponse(message);
                break;
            }
            case 234: {
                concreteBidibMessage = new CommandStationDriveStateResponse(message);
                break;
            }
            case 227: {
                concreteBidibMessage = new CommandStationAccessoryAcknowledgeResponse(message);
                break;
            }
            case 228: {
                concreteBidibMessage = new CommandStationPomAcknowledgeResponse(message);
                break;
            }
            case 232: {
                concreteBidibMessage = new CommandStationRcPlusAcknowledgeResponse(message);
                break;
            }
            case 233: {
                concreteBidibMessage = new CommandStationM4AcknowledgeResponse(message);
                break;
            }
            case 235: {
                concreteBidibMessage = new CommandStationDccAdvAcknowledgeResponse(message);
                break;
            }
            case 231: {
                concreteBidibMessage = new CommandStationAccessoryManualResponse(message);
                break;
            }
            case 239: {
                concreteBidibMessage = new CommandStationProgStateResponse(message);
                break;
            }
            case 64: {
                concreteBidibMessage = new LcOutputMessage(message);
                break;
            }
            case 65: {
                concreteBidibMessage = new LcConfigSetMessage(message);
                break;
            }
            case 66: {
                concreteBidibMessage = new LcConfigGetMessage(message);
                break;
            }
            case 70: {
                concreteBidibMessage = new LcConfigXSetMessage(message);
                break;
            }
            case 71: {
                concreteBidibMessage = new LcConfigXGetMessage(message);
                break;
            }
            case 69: {
                concreteBidibMessage = new LcConfigXGetAllMessage(message);
                break;
            }
            case 67: {
                concreteBidibMessage = new LcKeyMessage(message);
                break;
            }
            case 68: {
                concreteBidibMessage = new LcPortQueryMessage(message);
                break;
            }
            case 63: {
                concreteBidibMessage = new LcPortQueryAllMessage(message);
                break;
            }
            case 76: {
                concreteBidibMessage = new LcMacroParaGetMessage(message);
                break;
            }
            case 75: {
                concreteBidibMessage = new LcMacroParaSetMessage(message);
                break;
            }
            case 74: {
                concreteBidibMessage = new LcMacroGetMessage(message);
                break;
            }
            case 73: {
                concreteBidibMessage = new LcMacroSetMessage(message);
                break;
            }
            case 72: {
                concreteBidibMessage = new LcMacroHandleMessage(message);
                break;
            }
            case 194: {
                concreteBidibMessage = new LcConfigResponse(message);
                break;
            }
            case 198: {
                concreteBidibMessage = new LcConfigXResponse(message);
                break;
            }
            case 195: {
                concreteBidibMessage = new LcKeyResponse(message);
                break;
            }
            case 201: {
                concreteBidibMessage = new LcMacroResponse(message);
                break;
            }
            case 202: {
                concreteBidibMessage = new LcMacroParaResponse(message);
                break;
            }
            case 200: {
                concreteBidibMessage = new LcMacroStateResponse(message);
                break;
            }
            case 193: {
                concreteBidibMessage = new LcNotAvailableResponse(message);
                break;
            }
            case 192: {
                concreteBidibMessage = new LcStatResponse(message);
                break;
            }
            case 196: {
                concreteBidibMessage = new LcWaitResponse(message);
                break;
            }
            case 57: {
                concreteBidibMessage = new AccessoryGetMessage(message);
                break;
            }
            case 56: {
                concreteBidibMessage = new AccessorySetMessage(message);
                break;
            }
            case 60: {
                concreteBidibMessage = new AccessoryGetAllMessage(message);
                break;
            }
            case 59: {
                concreteBidibMessage = new AccessoryParaGetMessage(message);
                break;
            }
            case 58: {
                concreteBidibMessage = new AccessoryParaSetMessage(message);
                break;
            }
            case 185: {
                concreteBidibMessage = new AccessoryParaResponse(message);
                break;
            }
            case 184: {
                concreteBidibMessage = new AccessoryStateResponse(message);
                break;
            }
            case 186: {
                concreteBidibMessage = new AccessoryNotifyResponse(message);
                break;
            }
            case 142: {
                concreteBidibMessage = new StallResponse(message);
                break;
            }
            case 138: {
                concreteBidibMessage = new GetPacketCapacityMessage(message);
                break;
            }
            case 254: {
                concreteBidibMessage = new LocalProtocolSignatureMessage(message);
                break;
            }
            case 255: {
                concreteBidibMessage = new LocalLinkMessage(message);
                break;
            }
            case 209: {
                concreteBidibMessage = new GuestRequestUnsubscribeMessage(message);
                break;
            }
            case 208: {
                concreteBidibMessage = new GuestRequestSubscribeMessage(message);
                break;
            }
            case 80: {
                concreteBidibMessage = new GuestResponseSubscriptionCountMessage(message);
                break;
            }
            case 81: {
                concreteBidibMessage = new GuestResponseSubscriptionMessage(message);
                break;
            }
            case 210: {
                concreteBidibMessage = new GuestRequestSendMessage(message);
                break;
            }
            case 83: {
                concreteBidibMessage = new GuestResponseNotifyMessage(message);
                break;
            }
            case 82: {
                concreteBidibMessage = new GuestResponseSentMessage(message);
                break;
            }
            default: {
                concreteBidibMessage = new UnknownCommandMessage(message);
            }
        }
        if (concreteBidibMessage instanceof BidibCommand) {
            MessageType mt = this.messageTypeMap.get(type);
            if (mt != null) {
                if (mt.getAnswerSize() != null) {
                    ((BidibCommand)((Object)concreteBidibMessage)).setAnswerSize(mt.getAnswerSize());
                }
            } else {
                this.logWarnMessage("Unknown message detected, cannot set answer size: {}", concreteBidibMessage);
            }
        }
        return concreteBidibMessage;
    }

    private <T extends BidibCommand> T initializeCommand(T bidibCommand) {
        MessageType mt = this.messageTypeMap.get(ByteUtils.getInt(bidibCommand.getType()));
        if (mt != null && mt.getAnswerSize() != null) {
            bidibCommand.setAnswerSize(mt.getAnswerSize());
        }
        return bidibCommand;
    }

    public LocalBidibDownMessage createLocalBidibDown(BidibCommand wrappedMessage) {
        LocalBidibDownMessage bidibCommand = new LocalBidibDownMessage(0, wrappedMessage.getMessageContent());
        return this.initializeCommand(bidibCommand);
    }

    public SysGetMagicMessage createSysGetMagic() {
        SysGetMagicMessage bidibCommand = new SysGetMagicMessage();
        return this.initializeCommand(bidibCommand);
    }

    public CommandStationSetStateMessage createCommandStationSetState(CommandStationState state) {
        CommandStationSetStateMessage bidibCommand = new CommandStationSetStateMessage(state);
        return this.initializeCommand(bidibCommand);
    }

    public CommandStationDriveMessage createCommandStationDrive(int address, SpeedStepsEnum speedSteps, Integer speed, DirectionEnum direction, BitSet activeFunctions, BitSet functions) {
        CommandStationDriveMessage bidibCommand = new CommandStationDriveMessage(address, speedSteps, speed, direction, activeFunctions, functions);
        return this.initializeCommand(bidibCommand);
    }

    public BoostQueryMessage createBoosterQuery() {
        BoostQueryMessage bidibCommand = new BoostQueryMessage();
        return this.initializeCommand(bidibCommand);
    }

    public BidibCommand createBoosterSetState(BoosterState state, boolean broadcast) {
        BidibCommandMessage bidibCommand = state == BoosterState.ON ? new BoostOnMessage(broadcast ? (byte)0 : 1) : new BoostOffMessage(broadcast ? (byte)0 : 1);
        return this.initializeCommand(bidibCommand);
    }

    public CommandStationAccessoryMessage createCommandStationAccessory(int address, AddressTypeEnum addressType, TimingControlEnum timingControl, ActivateCoilEnum activateCoil, int aspect, TimeBaseUnitEnum timeBaseUnit, int time) {
        CommandStationAccessoryMessage bidibCommand = new CommandStationAccessoryMessage(address, addressType, timingControl, activateCoil, aspect, timeBaseUnit, time);
        return this.initializeCommand(bidibCommand);
    }

    public GetPacketCapacityMessage createGetPacketCapacity() {
        GetPacketCapacityMessage bidibCommand = new GetPacketCapacityMessage();
        return this.initializeCommand(bidibCommand);
    }

    public FeatureSetMessage createFeatureSet(int number, int value) {
        FeatureSetMessage bidibCommand = new FeatureSetMessage(number, value);
        return this.initializeCommand(bidibCommand);
    }

    public FeatureGetMessage createFeatureGet(int number) {
        FeatureGetMessage bidibCommand = new FeatureGetMessage(number);
        return this.initializeCommand(bidibCommand);
    }

    public FeatureGetNextMessage createFeatureGetNext() {
        FeatureGetNextMessage bidibCommand = new FeatureGetNextMessage();
        return this.initializeCommand(bidibCommand);
    }

    public FeatureGetAllMessage createFeatureGetAll() {
        FeatureGetAllMessage bidibCommand = new FeatureGetAllMessage();
        return this.initializeCommand(bidibCommand);
    }

    public FeatureGetAllMessage createFeatureGetAll(int startStreaming) {
        FeatureGetAllMessage bidibCommand = new FeatureGetAllMessage(startStreaming);
        return this.initializeCommand(bidibCommand);
    }

    public SysClockMessage createSysClock(LocalDateTime date, int factor) {
        SysClockMessage bidibCommand = new SysClockMessage(date, factor);
        return this.initializeCommand(bidibCommand);
    }

    public SysDisableMessage createSysDisable() {
        SysDisableMessage bidibCommand = new SysDisableMessage();
        return this.initializeCommand(bidibCommand);
    }

    public SysEnableMessage createSysEnable() {
        SysEnableMessage bidibCommand = new SysEnableMessage();
        return this.initializeCommand(bidibCommand);
    }

    public SysEnableMessage createSysEnable(int classEnableL, int classEnableH) {
        SysEnableMessage bidibCommand = new SysEnableMessage(classEnableL, classEnableH);
        return this.initializeCommand(bidibCommand);
    }

    public StringGetMessage createStringGet(int namespace, int stringId) {
        StringGetMessage bidibCommand = new StringGetMessage(namespace, stringId);
        return this.initializeCommand(bidibCommand);
    }

    public StringSetMessage createStringSet(int namespace, int stringId, String value) {
        StringSetMessage bidibCommand = new StringSetMessage(namespace, stringId, value);
        return this.initializeCommand(bidibCommand);
    }

    public LocalPingMessage createLocalPing() {
        LocalPingMessage bidibCommand = new LocalPingMessage();
        return this.initializeCommand(bidibCommand);
    }

    public LocalDiscoverMessage createLocalDiscover() {
        LocalDiscoverMessage bidibCommand = new LocalDiscoverMessage();
        return this.initializeCommand(bidibCommand);
    }

    public LocalBidibDownMessage createLocalBidibDown(byte[] wrappedMessage) {
        LocalBidibDownMessage bidibCommand = new LocalBidibDownMessage(0, wrappedMessage);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLogonMessage createLocalLogon(long uniqueId) {
        LocalLogonMessage bidibCommand = new LocalLogonMessage(uniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLogonAckMessage createLocalLogonAckRequest(int localNodeAddr, long partnerUniqueId) throws ProtocolException {
        LocalLogonAckMessage bidibCommand = new LocalLogonAckMessage(localNodeAddr, partnerUniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLogonRejectedMessage createLocalLogonRejected(long uniqueId) {
        LocalLogonRejectedMessage bidibCommand = new LocalLogonRejectedMessage(uniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLogoffMessage createLocalLogoff(long uniqueId) {
        LocalLogoffMessage bidibCommand = new LocalLogoffMessage(uniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public SysGetUniqueIdMessage createSysGetUniqueId() {
        SysGetUniqueIdMessage bidibCommand = new SysGetUniqueIdMessage();
        return this.initializeCommand(bidibCommand);
    }

    public SysGetSwVersionMessage createSysGetSwVersion() {
        SysGetSwVersionMessage bidibCommand = new SysGetSwVersionMessage();
        return this.initializeCommand(bidibCommand);
    }

    public SysGetPVersionMessage createSysGetPVersion() {
        SysGetPVersionMessage bidibCommand = new SysGetPVersionMessage();
        return this.initializeCommand(bidibCommand);
    }

    public VendorGetMessage createVendorGet(String name) {
        VendorGetMessage bidibCommand = new VendorGetMessage(name);
        return this.initializeCommand(bidibCommand);
    }

    public VendorSetMessage createVendorSet(String name, String value) {
        VendorSetMessage bidibCommand = new VendorSetMessage(name, value);
        return this.initializeCommand(bidibCommand);
    }

    public NodeTabGetAllMessage createNodeTabGetAll() {
        NodeTabGetAllMessage bidibCommand = new NodeTabGetAllMessage();
        return this.initializeCommand(bidibCommand);
    }

    public BidibCommand createNodeTabGetNext() {
        NodeTabGetNextMessage bidibCommand = new NodeTabGetNextMessage();
        return this.initializeCommand(bidibCommand);
    }

    public AccessoryGetMessage createAccessoryGet(int accessoryNumber) {
        AccessoryGetMessage bidibCommand = new AccessoryGetMessage(accessoryNumber);
        return this.initializeCommand(bidibCommand);
    }

    public AccessoryGetAllMessage createAccessoryGetAll() {
        AccessoryGetAllMessage bidibCommand = new AccessoryGetAllMessage();
        return this.initializeCommand(bidibCommand);
    }

    public AccessorySetMessage createAccessorySet(int accessoryNumber, int aspectNumber) {
        AccessorySetMessage bidibCommand = new AccessorySetMessage(accessoryNumber, aspectNumber);
        return this.initializeCommand(bidibCommand);
    }

    public AccessoryParaGetMessage createAccessoryParaGet(int accessoryNumber, int parameterNumber) {
        AccessoryParaGetMessage bidibCommand = new AccessoryParaGetMessage(accessoryNumber, parameterNumber);
        return this.initializeCommand(bidibCommand);
    }

    public AccessoryParaSetMessage createAccessoryParaSet(int accessoryNumber, int parameterNumber, byte[] value) {
        AccessoryParaSetMessage bidibCommand = new AccessoryParaSetMessage(accessoryNumber, parameterNumber, value);
        return this.initializeCommand(bidibCommand);
    }

    public LcMacroGetMessage createLcMacroGet(int macroNumber, int stepNumber) {
        LcMacroGetMessage bidibCommand = new LcMacroGetMessage(macroNumber, stepNumber);
        return this.initializeCommand(bidibCommand);
    }

    public LcMacroSetMessage createLcMacroSet(LcMacro macroStep) {
        LcMacroSetMessage bidibCommand = new LcMacroSetMessage(macroStep);
        return this.initializeCommand(bidibCommand);
    }

    public LcMacroParaGetMessage createLcMacroParaGet(int macroNumber, int parameter) {
        LcMacroParaGetMessage bidibCommand = new LcMacroParaGetMessage(macroNumber, parameter);
        return this.initializeCommand(bidibCommand);
    }

    public LcMacroParaSetMessage createLcMacroParaSet(int macroNumber, int parameter, byte ... value) {
        LcMacroParaSetMessage bidibCommand = new LcMacroParaSetMessage(macroNumber, parameter, value);
        return this.initializeCommand(bidibCommand);
    }

    public LcMacroHandleMessage createLcMacroHandle(int macroNumber, LcMacroOperationCode macroOperationCode) {
        LcMacroHandleMessage bidibCommand = new LcMacroHandleMessage(macroNumber, macroOperationCode);
        return this.initializeCommand(bidibCommand);
    }

    public LcConfigGetMessage createLcConfigGet(PortModelEnum portModel, LcOutputType outputType, int outputNumber) {
        BidibPort bidibPort = BidibPort.prepareBidibPort(portModel, outputType, outputNumber);
        LcConfigGetMessage bidibCommand = new LcConfigGetMessage(bidibPort);
        return this.initializeCommand(bidibCommand);
    }

    public LcConfigSetMessage createLcConfigSet(PortModelEnum portModel, LcConfig config) {
        LcConfigSetMessage bidibCommand = new LcConfigSetMessage(portModel, config);
        return this.initializeCommand(bidibCommand);
    }

    public LcConfigXGetMessage createLcConfigXGet(PortModelEnum portModel, LcOutputType outputType, int outputNumber) {
        BidibPort bidibPort = BidibPort.prepareBidibPort(portModel, outputType, outputNumber);
        LcConfigXGetMessage bidibCommand = new LcConfigXGetMessage(bidibPort);
        return this.initializeCommand(bidibCommand);
    }

    public LcConfigXGetAllMessage createLcConfigXGetAll() {
        LcConfigXGetAllMessage bidibCommand = new LcConfigXGetAllMessage();
        return this.initializeCommand(bidibCommand);
    }

    public LcConfigXGetAllMessage createLcConfigXGetAll(PortModelEnum portModel, LcOutputType lcOutputType, int rangeFrom, int rangeTo) {
        BidibPort bidibPortFrom = BidibPort.prepareBidibPort(portModel, lcOutputType, rangeFrom);
        BidibPort bidibPortTo = BidibPort.prepareBidibPort(portModel, lcOutputType, rangeTo);
        LcConfigXGetAllMessage bidibCommand = new LcConfigXGetAllMessage(bidibPortFrom, bidibPortTo);
        return this.initializeCommand(bidibCommand);
    }

    public LcPortQueryAllMessage createPortQueryAll(int portTypeMask, int rangeFrom, int rangeTo) {
        LcPortQueryAllMessage bidibCommand = new LcPortQueryAllMessage(portTypeMask, rangeFrom, rangeTo);
        return this.initializeCommand(bidibCommand);
    }

    public LcKeyMessage createLcKey(int portId) {
        LcKeyMessage bidibCommand = new LcKeyMessage(portId);
        return this.initializeCommand(bidibCommand);
    }

    public LcOutputMessage createLcOutputMessage(PortModelEnum portModel, LcOutputType outputType, int outputNumber, int state) {
        BidibPort bidibPort = BidibPort.prepareBidibPort(portModel, outputType, outputNumber);
        LcOutputMessage bidibCommand = new LcOutputMessage(bidibPort, state);
        return this.initializeCommand(bidibCommand);
    }

    public LcPortQueryMessage createLcPortQuery(PortModelEnum portModel, LcOutputType outputType, int outputNumber) {
        BidibPort bidibPort = BidibPort.prepareBidibPort(portModel, outputType, outputNumber);
        LcPortQueryMessage bidibCommand = new LcPortQueryMessage(bidibPort);
        return this.initializeCommand(bidibCommand);
    }

    public FwUpdateOpMessage createFwUpdateOp(FirmwareUpdateOperation operation, byte ... data) {
        FwUpdateOpMessage bidibCommand = new FwUpdateOpMessage(operation, data);
        return this.initializeCommand(bidibCommand);
    }

    public VendorEnableMessage createVendorEnable(long uniqueId) {
        VendorEnableMessage bidibCommand = new VendorEnableMessage(uniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public VendorDisableMessage createVendorDisable() {
        VendorDisableMessage bidibCommand = new VendorDisableMessage();
        return this.initializeCommand(bidibCommand);
    }

    public SysMagicResponse createSysMagicResponse(byte[] addr, int num, int magic) throws ProtocolException {
        SysMagicResponse concreteBidibMessage = new SysMagicResponse(addr, num, magic);
        return concreteBidibMessage;
    }

    public SysErrorResponse createSysErrorResponse(byte[] addr, int num, SysErrorEnum sysError, byte ... reason) throws ProtocolException {
        SysErrorResponse concreteBidibMessage = new SysErrorResponse(addr, num, sysError, reason);
        return concreteBidibMessage;
    }

    public SysIdentifyMessage createSysIdentify(IdentifyState identifyState) throws ProtocolException {
        SysIdentifyMessage bidibCommand = new SysIdentifyMessage(identifyState);
        return this.initializeCommand(bidibCommand);
    }

    public SysIdentifyStateResponse createSysIdentifyStateResponse(byte[] addr, int num, IdentifyState identifyState) throws ProtocolException {
        SysIdentifyStateResponse concreteBidibMessage = new SysIdentifyStateResponse(addr, num, identifyState);
        return concreteBidibMessage;
    }

    public SysUniqueIdResponse createSysUniqueIdResponse(byte[] addr, int num, long uniqueId) throws ProtocolException {
        SysUniqueIdResponse concreteBidibMessage = new SysUniqueIdResponse(addr, num, uniqueId);
        return concreteBidibMessage;
    }

    public SysSwVersionResponse createSysSwVersionResponse(byte[] addr, int num, SoftwareVersion softwareVersion) throws ProtocolException {
        SysSwVersionResponse concreteBidibMessage = new SysSwVersionResponse(addr, num, softwareVersion);
        return concreteBidibMessage;
    }

    public SysPVersionResponse createSysProtocolVersionResponse(byte[] addr, int num, ProtocolVersion protocolVersion) throws ProtocolException {
        SysPVersionResponse concreteBidibMessage = new SysPVersionResponse(addr, num, protocolVersion);
        return concreteBidibMessage;
    }

    public SysResetMessage createSysResetMessage() throws ProtocolException {
        SysResetMessage bidibCommand = new SysResetMessage();
        return this.initializeCommand(bidibCommand);
    }

    public SysPingMessage createSysPingMessage(int marker) throws ProtocolException {
        SysPingMessage bidibCommand = new SysPingMessage(marker);
        return this.initializeCommand(bidibCommand);
    }

    public SysPongResponse createSysPongResponse(byte[] addr, int num, int marker) throws ProtocolException {
        SysPongResponse concreteBidibMessage = new SysPongResponse(addr, num, marker);
        return concreteBidibMessage;
    }

    public PacketCapacityResponse createPacketCapacityResponse(byte[] addr, int num, int capacity) throws ProtocolException {
        PacketCapacityResponse concreteBidibMessage = new PacketCapacityResponse(addr, num, capacity);
        return concreteBidibMessage;
    }

    public FeatureCountResponse createFeatureCountResponse(byte[] addr, int num, int featureCount, int streamingSupported) throws ProtocolException {
        FeatureCountResponse featureCountResponse = new FeatureCountResponse(addr, num, featureCount, streamingSupported);
        return featureCountResponse;
    }

    public FeatureResponse createFeatureResponse(byte[] addr, int num, Feature feature) throws ProtocolException {
        FeatureResponse featureResponse = new FeatureResponse(addr, num, feature.getType(), feature.getValue());
        return featureResponse;
    }

    public FeatureNotAvailableResponse createFeatureNaResponse(byte[] addr, int num, int featureNum) throws ProtocolException {
        FeatureNotAvailableResponse featureNotAvailableResponse = new FeatureNotAvailableResponse(addr, num, featureNum);
        return featureNotAvailableResponse;
    }

    public NodeTabCountResponse createNodeTabCountResponse(byte[] addr, int num, int tabCount) throws ProtocolException {
        NodeTabCountResponse nodeTabCountResponse = new NodeTabCountResponse(addr, num, tabCount);
        return nodeTabCountResponse;
    }

    public NodeTabResponse createNodeTabResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        NodeTabResponse nodeTabResponse = new NodeTabResponse(addr, num, version, localAddr, uniqueId);
        return nodeTabResponse;
    }

    public NodeNotAvailableResponse createNodeNotAvailableResponse(byte[] addr, int num, int localAddr) throws ProtocolException {
        NodeNotAvailableResponse nodeTabResponse = new NodeNotAvailableResponse(addr, num, localAddr);
        return nodeTabResponse;
    }

    public CommandStationStateResponse createCommandStationStateResponse(byte[] addr, int num, CommandStationState csState) throws ProtocolException {
        CommandStationStateResponse concreteBidibMessage = new CommandStationStateResponse(addr, num, csState.getType());
        return concreteBidibMessage;
    }

    public CommandStationDriveAcknowledgeResponse createCommandStationDriveAckResponse(byte[] addr, int num, AddressData decoderAddress, DriveAcknowledge driveAcknowledge, Integer acknowledgedMessageNumber) throws ProtocolException {
        CommandStationDriveAcknowledgeResponse concreteBidibMessage = new CommandStationDriveAcknowledgeResponse(addr, num, decoderAddress, driveAcknowledge.getType(), acknowledgedMessageNumber);
        return concreteBidibMessage;
    }

    public CommandStationDriveManualResponse createCommandStationDriveManualResponse(byte[] addr, int num, DriveState driveState) throws ProtocolException {
        CommandStationDriveManualResponse concreteBidibMessage = new CommandStationDriveManualResponse(addr, num, driveState);
        return concreteBidibMessage;
    }

    public CommandStationDriveStateResponse createCommandStationDriveStateResponse(byte[] addr, int num, int opMode, DriveState driveState) throws ProtocolException {
        CommandStationDriveStateResponse concreteBidibMessage = new CommandStationDriveStateResponse(addr, num, opMode, driveState);
        return concreteBidibMessage;
    }

    public CommandStationDriveStateResponse createCommandStationDriveStateResponse(byte[] addr, int num, int opMode, DriveState driveState, byte ... optionalData) throws ProtocolException {
        CommandStationDriveStateResponse concreteBidibMessage = new CommandStationDriveStateResponse(addr, num, opMode, driveState, optionalData);
        return concreteBidibMessage;
    }

    public CommandStationQueryMessage createCommandStationQueryMessage(CsQueryTypeEnum queryType, Integer address) {
        CommandStationQueryMessage bidibCommand = null;
        bidibCommand = address != null ? new CommandStationQueryMessage(queryType, address) : new CommandStationQueryMessage(queryType);
        return this.initializeCommand(bidibCommand);
    }

    public BoostDiagnosticResponse createBoosterDiagnosticResponse(byte[] addr, int num, int current, int voltage, int temperature) throws ProtocolException {
        BoostDiagnosticResponse concreteBidibMessage = new BoostDiagnosticResponse(addr, num, ConversionUtils.encodeCurrent(current), ConversionUtils.encodeVoltage(voltage), ConversionUtils.encodeTemperature(temperature));
        return concreteBidibMessage;
    }

    public BoostStatResponse createBoosterStateResponse(byte[] addr, int num, BoosterState boosterState) throws ProtocolException {
        BoostStatResponse concreteBidibMessage = new BoostStatResponse(addr, num, boosterState);
        return concreteBidibMessage;
    }

    public FeedbackMultipleResponse createOccupancyMultipleResponse(byte[] addr, int num, int baseAddress, int feedbackSize, byte[] feedbackMultiple) throws ProtocolException {
        FeedbackMultipleResponse concreteBidibMessage = new FeedbackMultipleResponse(addr, num, ByteUtils.getLowByte(baseAddress), ByteUtils.getLowByte(feedbackSize), feedbackMultiple);
        return concreteBidibMessage;
    }

    public BidibMessage createOccupancyStateResponse(byte[] addr, int num, int detectorNumber, OccupationState occupationState, Integer timestamp) throws ProtocolException {
        BidibMessage concreteBidibMessage = null;
        concreteBidibMessage = OccupationState.FREE == occupationState ? (timestamp != null ? new FeedbackFreeResponse(addr, num, detectorNumber, timestamp) : new FeedbackFreeResponse(addr, num, detectorNumber)) : (timestamp != null ? new FeedbackOccupiedResponse(addr, num, detectorNumber, timestamp) : new FeedbackOccupiedResponse(addr, num, detectorNumber));
        return concreteBidibMessage;
    }

    public FeedbackSpeedResponse createOccupancySpeedResponse(byte[] addr, int num, AddressData decoderAddress, int speed) throws ProtocolException {
        FeedbackSpeedResponse concreteBidibMessage = new FeedbackSpeedResponse(addr, num, decoderAddress.getAddress(), speed);
        return concreteBidibMessage;
    }

    public FeedbackConfidenceResponse createOccupancyConfidenceResponse(byte[] addr, int num, int valid, int freeze, int signal) throws ProtocolException {
        FeedbackConfidenceResponse concreteBidibMessage = new FeedbackConfidenceResponse(addr, num, ByteUtils.getLowByte(valid), ByteUtils.getLowByte(freeze), ByteUtils.getLowByte(signal));
        return concreteBidibMessage;
    }

    public LocalLogonAckMessage createLocalLogonAckResponse(int localNodeAddr, long uniqueId) throws ProtocolException {
        LocalLogonAckMessage concreteBidibMessage = new LocalLogonAckMessage(localNodeAddr, uniqueId);
        return concreteBidibMessage;
    }

    public LocalPongResponse createLocalPongResponse(byte[] addr) throws ProtocolException {
        LocalPongResponse concreteBidibMessage = new LocalPongResponse(addr, 0);
        return concreteBidibMessage;
    }

    public NodeNewResponse createNodeNewResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        NodeNewResponse concreteBidibMessage = new NodeNewResponse(addr, num, version, localAddr, uniqueId);
        return concreteBidibMessage;
    }

    public NodeLostResponse createNodeLostResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        NodeLostResponse concreteBidibMessage = new NodeLostResponse(addr, num, version, localAddr, uniqueId);
        return concreteBidibMessage;
    }

    public StringResponse createStringResponse(byte[] addr, int num, StringData stringData) throws ProtocolException {
        StringResponse concreteBidibMessage = new StringResponse(addr, num, stringData);
        return concreteBidibMessage;
    }

    public LcConfigXResponse createLcConfigXResponse(byte[] addr, int num, LcConfigX lcConfigX, PortModelEnum portModelEnum) throws ProtocolException {
        LcConfigXResponse concreteBidibMessage = new LcConfigXResponse(addr, num, lcConfigX, portModelEnum);
        return concreteBidibMessage;
    }

    public LcStatResponse createLcStatResponse(byte[] addr, int num, BidibPort bidibPort, int portStatus) throws ProtocolException {
        LcStatResponse concreteBidibMessage = new LcStatResponse(addr, num, bidibPort, ByteUtils.getLowByte(portStatus));
        return concreteBidibMessage;
    }

    public LcNotAvailableResponse createLcNaResponse(byte[] addr, int num, BidibPort bidibPort) throws ProtocolException {
        LcNotAvailableResponse concreteBidibMessage = new LcNotAvailableResponse(addr, num, bidibPort);
        return concreteBidibMessage;
    }

    public LcMacroResponse createLcMacroResponse(byte[] addr, int num, int macroNumber, int stepNumber, LcMacro lcMacro) throws ProtocolException {
        LcMacroResponse concreteBidibMessage = new LcMacroResponse(addr, num, macroNumber, stepNumber, lcMacro);
        return concreteBidibMessage;
    }

    public LcMacroParaResponse createLcMacroParaResponse(byte[] addr, int num, int macroNumber, int paramNumber, byte[] macroParam) throws ProtocolException {
        LcMacroParaResponse concreteBidibMessage = new LcMacroParaResponse(addr, num, macroNumber, paramNumber, macroParam);
        return concreteBidibMessage;
    }

    public AccessoryStateResponse createAccessoryStateResponse(byte[] addr, int num, int accessoryNumber, int aspect, byte[] value) throws ProtocolException {
        AccessoryStateResponse concreteBidibMessage = new AccessoryStateResponse(addr, num, accessoryNumber, aspect, value);
        return concreteBidibMessage;
    }

    public AccessoryParaResponse createAccessoryParaResponse(byte[] addr, int num, int accessoryNumber, int paramNumber, int[] accessoryParam) throws ProtocolException {
        AccessoryParaResponse concreteBidibMessage = new AccessoryParaResponse(addr, num, accessoryNumber, paramNumber, accessoryParam);
        return concreteBidibMessage;
    }

    public FeedbackGetAddressRangeMessage createFeedbackGetAddressRange(int begin, int end) throws ProtocolException {
        FeedbackGetAddressRangeMessage bidibCommand = new FeedbackGetAddressRangeMessage(begin, end);
        return this.initializeCommand(bidibCommand);
    }

    public FeedbackGetRangeMessage createFeedbackGetRange(int begin, int end) throws ProtocolException {
        FeedbackGetRangeMessage bidibCommand = new FeedbackGetRangeMessage(begin, end);
        return this.initializeCommand(bidibCommand);
    }

    public FeedbackGetConfidenceMessage createFeedbackGetConfidence() throws ProtocolException {
        FeedbackGetConfidenceMessage bidibCommand = new FeedbackGetConfidenceMessage();
        return this.initializeCommand(bidibCommand);
    }

    public GuestRequestSendMessage createGuestRequestSendMessage(TargetModeEnum targetMode, byte[] targetModeUniqueId, byte ... wrappedContent) throws ProtocolException {
        GuestRequestSendMessage bidibCommand = new GuestRequestSendMessage(targetMode, targetModeUniqueId, wrappedContent);
        return this.initializeCommand(bidibCommand);
    }

    public GuestRequestSendMessage createGuestRequestSendMessage(TargetModeEnum targetMode, byte ... wrappedContent) throws ProtocolException {
        if (TargetModeEnum.BIDIB_TARGET_MODE_UID == targetMode) {
            throw new ProtocolException("BIDIB_TARGET_MODE_UID must provide uniqueId of the target node.");
        }
        GuestRequestSendMessage bidibCommand = new GuestRequestSendMessage(targetMode, wrappedContent);
        return this.initializeCommand(bidibCommand);
    }

    public GuestRequestSubscribeMessage createGuestRequestSubscribeMessage(TargetModeEnum targetMode, byte[] targetModeUniqueId, int subscription) throws ProtocolException {
        GuestRequestSubscribeMessage bidibCommand = new GuestRequestSubscribeMessage(targetMode, targetModeUniqueId, subscription);
        return this.initializeCommand(bidibCommand);
    }

    public GuestRequestSubscribeMessage createGuestRequestSubscribeMessage(TargetModeEnum targetMode, int subscription) throws ProtocolException {
        if (TargetModeEnum.BIDIB_TARGET_MODE_UID == targetMode) {
            throw new ProtocolException("BIDIB_TARGET_MODE_UID must provide uniqueId of the target node.");
        }
        GuestRequestSubscribeMessage bidibCommand = new GuestRequestSubscribeMessage(targetMode, subscription);
        return this.initializeCommand(bidibCommand);
    }

    public GuestResponseSubscriptionCountMessage createGuestResponseSubscriptionCountMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int ackSequence, int result, int nodeCount) throws ProtocolException {
        GuestResponseSubscriptionCountMessage bidibCommand = new GuestResponseSubscriptionCountMessage(addr, num, targetMode, targetModeUniqueId, ackSequence, result, nodeCount);
        return this.initializeCommand(bidibCommand);
    }

    public GuestResponseSubscriptionMessage createGuestResponseSubscriptionMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int ackSequence, int result, int nodeCount) throws ProtocolException {
        GuestResponseSubscriptionMessage bidibCommand = new GuestResponseSubscriptionMessage(addr, num, targetMode, targetModeUniqueId, ackSequence, result, nodeCount);
        return this.initializeCommand(bidibCommand);
    }

    public GuestResponseSentMessage createGuestResponseSentMessage(byte[] addr, int num, TargetModeEnum targetMode, byte[] targetModeUniqueId, int ackSequence, int result) throws ProtocolException {
        GuestResponseSentMessage bidibCommand = new GuestResponseSentMessage(addr, num, targetMode, targetModeUniqueId, ackSequence, result, new byte[0]);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkDescriptorUid(long uniqueId) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(uniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkProdString(String prodString) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(new byte[]{0}, 0, 0, prodString);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkUserString(String userString) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(new byte[]{0}, 0, 1, userString);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkNetBidibRole(NetBidibRole netBidibRole) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(netBidibRole);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkProtocolVersion(ProtocolVersion pVersion) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(pVersion);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkPairingRequest(long ownUniqueId, long partnerUniqueId, int pairingTimeout) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(ownUniqueId, partnerUniqueId, pairingTimeout);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkStatusPaired(long ownUniqueId, long partnerUniqueId) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(254, ownUniqueId, partnerUniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public LocalLinkMessage createLocalLinkStatusUnpaired(long ownUniqueId, long partnerUniqueId) throws ProtocolException {
        LocalLinkMessage bidibCommand = new LocalLinkMessage(253, ownUniqueId, partnerUniqueId);
        return this.initializeCommand(bidibCommand);
    }

    public LocalProtocolSignatureMessage createLocalProtocolSignature(String requestor) throws ProtocolException {
        LocalProtocolSignatureMessage bidibCommand = new LocalProtocolSignatureMessage(requestor);
        return this.initializeCommand(bidibCommand);
    }

    private <T extends NetBidibCommandMessage> T initializeCommand(T bidibCommand) {
        return bidibCommand;
    }

    public BidibCommand createLocalSync(int systemTime) {
        LocalSyncMessage bidibCommand = new LocalSyncMessage(systemTime);
        return this.initializeCommand(bidibCommand);
    }
}

