/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.BidibPort;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.LcConfigX;
import org.bidib.jbidibc.messages.LcMacro;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.SoftwareVersion;
import org.bidib.jbidibc.messages.StringData;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.enums.OccupationState;
import org.bidib.jbidibc.messages.enums.PortModelEnum;
import org.bidib.jbidibc.messages.enums.SysErrorEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.AccessoryNotifyResponse;
import org.bidib.jbidibc.messages.message.AccessoryParaResponse;
import org.bidib.jbidibc.messages.message.AccessoryStateResponse;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BoostDiagnosticResponse;
import org.bidib.jbidibc.messages.message.BoostStatResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveEventResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveManualResponse;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationM4AcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationProgStateResponse;
import org.bidib.jbidibc.messages.message.CommandStationRcPlusAcknowledgeResponse;
import org.bidib.jbidibc.messages.message.CommandStationStateResponse;
import org.bidib.jbidibc.messages.message.FeatureCountResponse;
import org.bidib.jbidibc.messages.message.FeatureNotAvailableResponse;
import org.bidib.jbidibc.messages.message.FeatureResponse;
import org.bidib.jbidibc.messages.message.FeedbackAccessoryResponse;
import org.bidib.jbidibc.messages.message.FeedbackAddressResponse;
import org.bidib.jbidibc.messages.message.FeedbackConfidenceResponse;
import org.bidib.jbidibc.messages.message.FeedbackCurrentResponse;
import org.bidib.jbidibc.messages.message.FeedbackCvResponse;
import org.bidib.jbidibc.messages.message.FeedbackDccAResponse;
import org.bidib.jbidibc.messages.message.FeedbackDynStateResponse;
import org.bidib.jbidibc.messages.message.FeedbackFreeResponse;
import org.bidib.jbidibc.messages.message.FeedbackMultipleResponse;
import org.bidib.jbidibc.messages.message.FeedbackOccupiedResponse;
import org.bidib.jbidibc.messages.message.FeedbackPositionResponse;
import org.bidib.jbidibc.messages.message.FeedbackRcPlusResponse;
import org.bidib.jbidibc.messages.message.FeedbackSpeedResponse;
import org.bidib.jbidibc.messages.message.FeedbackXPomResponse;
import org.bidib.jbidibc.messages.message.FwUpdateStatResponse;
import org.bidib.jbidibc.messages.message.GuestRequestSendMessage;
import org.bidib.jbidibc.messages.message.GuestRequestSubscribeMessage;
import org.bidib.jbidibc.messages.message.GuestRequestUnsubscribeMessage;
import org.bidib.jbidibc.messages.message.GuestResponseNotifyMessage;
import org.bidib.jbidibc.messages.message.GuestResponseSentMessage;
import org.bidib.jbidibc.messages.message.LcConfigResponse;
import org.bidib.jbidibc.messages.message.LcConfigXResponse;
import org.bidib.jbidibc.messages.message.LcKeyResponse;
import org.bidib.jbidibc.messages.message.LcMacroParaResponse;
import org.bidib.jbidibc.messages.message.LcMacroResponse;
import org.bidib.jbidibc.messages.message.LcMacroStateResponse;
import org.bidib.jbidibc.messages.message.LcNotAvailableResponse;
import org.bidib.jbidibc.messages.message.LcStatResponse;
import org.bidib.jbidibc.messages.message.LcWaitResponse;
import org.bidib.jbidibc.messages.message.LocalBidibUpResponse;
import org.bidib.jbidibc.messages.message.LocalLogoffMessage;
import org.bidib.jbidibc.messages.message.LocalLogonAckMessage;
import org.bidib.jbidibc.messages.message.LocalLogonMessage;
import org.bidib.jbidibc.messages.message.LocalLogonRejectedMessage;
import org.bidib.jbidibc.messages.message.LocalPingMessage;
import org.bidib.jbidibc.messages.message.LocalPongResponse;
import org.bidib.jbidibc.messages.message.NodeLostResponse;
import org.bidib.jbidibc.messages.message.NodeNewResponse;
import org.bidib.jbidibc.messages.message.NodeNotAvailableResponse;
import org.bidib.jbidibc.messages.message.NodeTabCountResponse;
import org.bidib.jbidibc.messages.message.NodeTabResponse;
import org.bidib.jbidibc.messages.message.PacketCapacityResponse;
import org.bidib.jbidibc.messages.message.ResponseFactory;
import org.bidib.jbidibc.messages.message.StallResponse;
import org.bidib.jbidibc.messages.message.StringResponse;
import org.bidib.jbidibc.messages.message.SysEnableMessage;
import org.bidib.jbidibc.messages.message.SysErrorResponse;
import org.bidib.jbidibc.messages.message.SysGetMagicMessage;
import org.bidib.jbidibc.messages.message.SysIdentifyStateResponse;
import org.bidib.jbidibc.messages.message.SysMagicResponse;
import org.bidib.jbidibc.messages.message.SysPVersionResponse;
import org.bidib.jbidibc.messages.message.SysPongResponse;
import org.bidib.jbidibc.messages.message.SysSwVersionResponse;
import org.bidib.jbidibc.messages.message.SysUniqueIdResponse;
import org.bidib.jbidibc.messages.message.VendorAckResponse;
import org.bidib.jbidibc.messages.message.VendorResponse;
import org.bidib.jbidibc.messages.message.netbidib.LocalLinkMessage;
import org.bidib.jbidibc.messages.message.netbidib.LocalProtocolSignatureMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;

public class BidibResponseFactory
implements ResponseFactory {
    @Override
    public void initialize() {
    }

    @Override
    public BidibMessageInterface createRaw(byte[] message) throws ProtocolException {
        BidibMessage result = new BidibMessage(message);
        return result;
    }

    @Override
    public BidibMessageInterface create(byte[] message) throws ProtocolException {
        BidibMessage concreteBidibMessage = new BidibMessage(message);
        int type = ByteUtils.getInt(concreteBidibMessage.getType());
        switch (type) {
            case 129: {
                concreteBidibMessage = new SysMagicResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 1: {
                concreteBidibMessage = new SysGetMagicMessage(message);
                break;
            }
            case 3: {
                concreteBidibMessage = new SysEnableMessage(message);
                break;
            }
            case 134: {
                concreteBidibMessage = new SysErrorResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 135: {
                concreteBidibMessage = new SysIdentifyStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 130: {
                concreteBidibMessage = new SysPongResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 131: {
                concreteBidibMessage = new SysPVersionResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 133: {
                concreteBidibMessage = new SysSwVersionResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 132: {
                concreteBidibMessage = new SysUniqueIdResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 137: {
                concreteBidibMessage = new NodeTabResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 140: {
                concreteBidibMessage = new NodeLostResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 139: {
                concreteBidibMessage = new NodeNotAvailableResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 141: {
                concreteBidibMessage = new NodeNewResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 136: {
                concreteBidibMessage = new NodeTabCountResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 143: {
                concreteBidibMessage = new FwUpdateStatResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 142: {
                concreteBidibMessage = new StallResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 138: {
                concreteBidibMessage = new PacketCapacityResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 144: {
                concreteBidibMessage = new FeatureResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 146: {
                concreteBidibMessage = new FeatureCountResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 145: {
                concreteBidibMessage = new FeatureNotAvailableResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 149: {
                concreteBidibMessage = new StringResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 252: {
                concreteBidibMessage = new LocalBidibUpResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 112: {
                concreteBidibMessage = new LocalLogonAckMessage(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 114: {
                concreteBidibMessage = new LocalLogonRejectedMessage(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 113: {
                concreteBidibMessage = new LocalPingMessage(message);
                break;
            }
            case 241: {
                concreteBidibMessage = new LocalPongResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum());
                break;
            }
            case 240: {
                concreteBidibMessage = new LocalLogonMessage(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 242: {
                concreteBidibMessage = new LocalLogoffMessage(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), concreteBidibMessage.getData());
                break;
            }
            case 243: {
                break;
            }
            case 225: {
                concreteBidibMessage = new CommandStationStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 226: {
                concreteBidibMessage = new CommandStationDriveAcknowledgeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 229: {
                concreteBidibMessage = new CommandStationDriveManualResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 230: {
                concreteBidibMessage = new CommandStationDriveEventResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 234: {
                concreteBidibMessage = new CommandStationDriveStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 227: {
                concreteBidibMessage = new CommandStationAccessoryAcknowledgeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 228: {
                concreteBidibMessage = new CommandStationPomAcknowledgeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 232: {
                concreteBidibMessage = new CommandStationRcPlusAcknowledgeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 233: {
                concreteBidibMessage = new CommandStationM4AcknowledgeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 235: {
                concreteBidibMessage = new CommandStationDccAdvAcknowledgeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 231: {
                concreteBidibMessage = new CommandStationAccessoryManualResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 239: {
                concreteBidibMessage = new CommandStationProgStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 163: {
                concreteBidibMessage = new FeedbackAddressResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 169: {
                concreteBidibMessage = new FeedbackConfidenceResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 167: {
                concreteBidibMessage = new FeedbackCurrentResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 161: {
                concreteBidibMessage = new FeedbackFreeResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 162: {
                concreteBidibMessage = new FeedbackMultipleResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 160: {
                concreteBidibMessage = new FeedbackOccupiedResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 172: {
                concreteBidibMessage = new FeedbackPositionResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 166: {
                concreteBidibMessage = new FeedbackSpeedResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 164: {
                concreteBidibMessage = new FeedbackAccessoryResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 165: {
                concreteBidibMessage = new FeedbackCvResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 168: {
                concreteBidibMessage = new FeedbackXPomResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 170: {
                concreteBidibMessage = new FeedbackDynStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 171: {
                int opCode = ByteUtils.getInt(concreteBidibMessage.getData()[1]);
                if ((opCode & 0x80) == 128) {
                    concreteBidibMessage = new FeedbackDccAResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                    break;
                }
                concreteBidibMessage = new FeedbackRcPlusResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 178: {
                concreteBidibMessage = new BoostDiagnosticResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 176: {
                concreteBidibMessage = new BoostStatResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 147: {
                concreteBidibMessage = new VendorResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 148: {
                concreteBidibMessage = new VendorAckResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 185: {
                concreteBidibMessage = new AccessoryParaResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 184: {
                concreteBidibMessage = new AccessoryStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 186: {
                concreteBidibMessage = new AccessoryNotifyResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 194: {
                concreteBidibMessage = new LcConfigResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 198: {
                concreteBidibMessage = new LcConfigXResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 195: {
                concreteBidibMessage = new LcKeyResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 201: {
                concreteBidibMessage = new LcMacroResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 202: {
                concreteBidibMessage = new LcMacroParaResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 200: {
                concreteBidibMessage = new LcMacroStateResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 193: {
                concreteBidibMessage = new LcNotAvailableResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 192: {
                concreteBidibMessage = new LcStatResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 196: {
                concreteBidibMessage = new LcWaitResponse(concreteBidibMessage.getAddr(), concreteBidibMessage.getNum(), (int)concreteBidibMessage.getType(), concreteBidibMessage.getData());
                break;
            }
            case 254: {
                concreteBidibMessage = new LocalProtocolSignatureMessage(message);
                break;
            }
            case 255: {
                concreteBidibMessage = new LocalLinkMessage(message);
                break;
            }
            case 209: {
                concreteBidibMessage = new GuestRequestUnsubscribeMessage(message);
                break;
            }
            case 208: {
                concreteBidibMessage = new GuestRequestSubscribeMessage(message);
                break;
            }
            case 210: {
                concreteBidibMessage = new GuestRequestSendMessage(message);
                break;
            }
            case 83: {
                concreteBidibMessage = new GuestResponseNotifyMessage(message);
                break;
            }
            case 82: {
                concreteBidibMessage = new GuestResponseSentMessage(message);
                break;
            }
            default: {
                StringBuilder msg = new StringBuilder("Got unknown response with type 0x");
                msg.append(ByteUtils.byteToHex(concreteBidibMessage.getType()));
                msg.append(". Complete message: ").append(ByteUtils.bytesToHex(message));
                throw new ProtocolException(msg.toString());
            }
        }
        return concreteBidibMessage;
    }

    public BidibMessage createSysMagicResponse(byte[] addr, int num, int magic) throws ProtocolException {
        SysMagicResponse concreteBidibMessage = new SysMagicResponse(addr, num, magic);
        return concreteBidibMessage;
    }

    public BidibMessage createSysErrorResponse(byte[] addr, int num, SysErrorEnum sysError, byte ... reason) throws ProtocolException {
        SysErrorResponse concreteBidibMessage = new SysErrorResponse(addr, num, sysError, reason);
        return concreteBidibMessage;
    }

    public BidibMessage createSysIdentifyStateResponse(byte[] addr, int num, IdentifyState identifyState) throws ProtocolException {
        SysIdentifyStateResponse concreteBidibMessage = new SysIdentifyStateResponse(addr, num, identifyState);
        return concreteBidibMessage;
    }

    public BidibMessage createSysUniqueIdResponse(byte[] addr, int num, long uniqueId) throws ProtocolException {
        SysUniqueIdResponse concreteBidibMessage = new SysUniqueIdResponse(addr, num, uniqueId);
        return concreteBidibMessage;
    }

    public BidibMessage createSysSwVersionResponse(byte[] addr, int num, SoftwareVersion softwareVersion) throws ProtocolException {
        SysSwVersionResponse concreteBidibMessage = new SysSwVersionResponse(addr, num, softwareVersion);
        return concreteBidibMessage;
    }

    public BidibMessage createSysProtocolVersionResponse(byte[] addr, int num, ProtocolVersion protocolVersion) throws ProtocolException {
        SysPVersionResponse concreteBidibMessage = new SysPVersionResponse(addr, num, protocolVersion);
        return concreteBidibMessage;
    }

    public BidibMessage createSysPongResponse(byte[] addr, int num, int marker) throws ProtocolException {
        SysPongResponse concreteBidibMessage = new SysPongResponse(addr, num, marker);
        return concreteBidibMessage;
    }

    public BidibMessage createPacketCapacityResponse(byte[] addr, int num, int capacity) throws ProtocolException {
        PacketCapacityResponse concreteBidibMessage = new PacketCapacityResponse(addr, num, capacity);
        return concreteBidibMessage;
    }

    public BidibMessage createFeatureCountResponse(byte[] addr, int num, int featureCount, int streamingSupported) throws ProtocolException {
        FeatureCountResponse featureCountResponse = new FeatureCountResponse(addr, num, featureCount, streamingSupported);
        return featureCountResponse;
    }

    public BidibMessage createFeatureResponse(byte[] addr, int num, Feature feature) throws ProtocolException {
        FeatureResponse featureResponse = new FeatureResponse(addr, num, feature.getType(), feature.getValue());
        return featureResponse;
    }

    public BidibMessage createFeatureNaResponse(byte[] addr, int num, int featureNum) throws ProtocolException {
        FeatureNotAvailableResponse featureNotAvailableResponse = new FeatureNotAvailableResponse(addr, num, featureNum);
        return featureNotAvailableResponse;
    }

    public BidibMessage createNodeTabCountResponse(byte[] addr, int num, int tabCount) throws ProtocolException {
        NodeTabCountResponse nodeTabCountResponse = new NodeTabCountResponse(addr, num, tabCount);
        return nodeTabCountResponse;
    }

    public BidibMessage createNodeTabResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        NodeTabResponse nodeTabResponse = new NodeTabResponse(addr, num, version, localAddr, uniqueId);
        return nodeTabResponse;
    }

    public BidibMessage createNodeNotAvailableResponse(byte[] addr, int num, int localAddr) throws ProtocolException {
        NodeNotAvailableResponse nodeTabResponse = new NodeNotAvailableResponse(addr, num, localAddr);
        return nodeTabResponse;
    }

    public BidibMessage createCommandStationStateResponse(byte[] addr, int num, CommandStationState csState) throws ProtocolException {
        CommandStationStateResponse concreteBidibMessage = new CommandStationStateResponse(addr, num, csState.getType());
        return concreteBidibMessage;
    }

    public BidibMessage createCommandStationDriveAckResponse(byte[] addr, int num, AddressData decoderAddress, DriveAcknowledge driveAcknowledge, Integer acknowledgedMessageNumber) throws ProtocolException {
        CommandStationDriveAcknowledgeResponse concreteBidibMessage = new CommandStationDriveAcknowledgeResponse(addr, num, decoderAddress, driveAcknowledge.getType(), acknowledgedMessageNumber);
        return concreteBidibMessage;
    }

    public BidibMessage createCommandStationDriveManualResponse(byte[] addr, int num, DriveState driveState) throws ProtocolException {
        CommandStationDriveManualResponse concreteBidibMessage = new CommandStationDriveManualResponse(addr, num, driveState);
        return concreteBidibMessage;
    }

    public BidibMessage createCommandStationDriveStateResponse(byte[] addr, int num, int opMode, DriveState driveState) throws ProtocolException {
        CommandStationDriveStateResponse concreteBidibMessage = new CommandStationDriveStateResponse(addr, num, opMode, driveState);
        return concreteBidibMessage;
    }

    public BidibMessage createBoosterDiagnosticResponse(byte[] addr, int num, int current, int voltage, int temperature) throws ProtocolException {
        BoostDiagnosticResponse concreteBidibMessage = new BoostDiagnosticResponse(addr, num, ConversionUtils.encodeCurrent(current), ConversionUtils.encodeVoltage(voltage), ConversionUtils.encodeTemperature(temperature));
        return concreteBidibMessage;
    }

    public BidibMessage createBoosterStateResponse(byte[] addr, int num, BoosterState boosterState) throws ProtocolException {
        BoostStatResponse concreteBidibMessage = new BoostStatResponse(addr, num, boosterState);
        return concreteBidibMessage;
    }

    public BidibMessage createOccupancyMultipleResponse(byte[] addr, int num, int baseAddress, int feedbackSize, byte[] feedbackMultiple) throws ProtocolException {
        FeedbackMultipleResponse concreteBidibMessage = new FeedbackMultipleResponse(addr, num, ByteUtils.getLowByte(baseAddress), ByteUtils.getLowByte(feedbackSize), feedbackMultiple);
        return concreteBidibMessage;
    }

    public BidibMessage createOccupancyStateResponse(byte[] addr, int num, int detectorNumber, OccupationState occupationState, Integer timestamp) throws ProtocolException {
        BidibMessage concreteBidibMessage = null;
        concreteBidibMessage = OccupationState.FREE == occupationState ? (timestamp != null ? new FeedbackFreeResponse(addr, num, detectorNumber, timestamp) : new FeedbackFreeResponse(addr, num, detectorNumber)) : (timestamp != null ? new FeedbackOccupiedResponse(addr, num, detectorNumber, timestamp) : new FeedbackOccupiedResponse(addr, num, detectorNumber));
        return concreteBidibMessage;
    }

    public BidibMessage createOccupancySpeedResponse(byte[] addr, int num, AddressData decoderAddress, int speed) throws ProtocolException {
        FeedbackSpeedResponse concreteBidibMessage = new FeedbackSpeedResponse(addr, num, decoderAddress.getAddress(), speed);
        return concreteBidibMessage;
    }

    public BidibMessage createOccupancyConfidenceResponse(byte[] addr, int num, int valid, int freeze, int signal) throws ProtocolException {
        FeedbackConfidenceResponse concreteBidibMessage = new FeedbackConfidenceResponse(addr, num, ByteUtils.getLowByte(valid), ByteUtils.getLowByte(freeze), ByteUtils.getLowByte(signal));
        return concreteBidibMessage;
    }

    public BidibMessage createLocalLogonAckResponse(int localNodeAddr, long uniqueId) throws ProtocolException {
        LocalLogonAckMessage concreteBidibMessage = new LocalLogonAckMessage(localNodeAddr, uniqueId);
        return concreteBidibMessage;
    }

    public BidibMessage createLocalPongResponse(byte[] addr) throws ProtocolException {
        LocalPongResponse concreteBidibMessage = new LocalPongResponse(addr, 0);
        return concreteBidibMessage;
    }

    public BidibMessage createLocalLogonRejected(long uniqueId) {
        LocalLogonRejectedMessage concreteBidibMessage = new LocalLogonRejectedMessage(uniqueId);
        return concreteBidibMessage;
    }

    public BidibMessage createNodeNewResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        NodeNewResponse concreteBidibMessage = new NodeNewResponse(addr, num, version, localAddr, uniqueId);
        return concreteBidibMessage;
    }

    public BidibMessage createNodeLostResponse(byte[] addr, int num, int version, int localAddr, long uniqueId) throws ProtocolException {
        NodeLostResponse concreteBidibMessage = new NodeLostResponse(addr, num, version, localAddr, uniqueId);
        return concreteBidibMessage;
    }

    public BidibMessage createStringResponse(byte[] addr, int num, StringData stringData) throws ProtocolException {
        StringResponse concreteBidibMessage = new StringResponse(addr, num, stringData);
        return concreteBidibMessage;
    }

    public BidibMessage createLcConfigXResponse(byte[] addr, int num, LcConfigX lcConfigX, PortModelEnum portModelEnum) throws ProtocolException {
        LcConfigXResponse concreteBidibMessage = new LcConfigXResponse(addr, num, lcConfigX, portModelEnum);
        return concreteBidibMessage;
    }

    public BidibMessage createLcStatResponse(byte[] addr, int num, BidibPort bidibPort, int portStatus) throws ProtocolException {
        LcStatResponse concreteBidibMessage = new LcStatResponse(addr, num, bidibPort, ByteUtils.getLowByte(portStatus));
        return concreteBidibMessage;
    }

    public BidibMessage createLcNaResponse(byte[] addr, int num, BidibPort bidibPort) throws ProtocolException {
        LcNotAvailableResponse concreteBidibMessage = new LcNotAvailableResponse(addr, num, bidibPort);
        return concreteBidibMessage;
    }

    public BidibMessage createLcMacroResponse(byte[] addr, int num, int macroNumber, int stepNumber, LcMacro lcMacro) throws ProtocolException {
        LcMacroResponse concreteBidibMessage = new LcMacroResponse(addr, num, macroNumber, stepNumber, lcMacro);
        return concreteBidibMessage;
    }

    public BidibMessage createLcMacroParaResponse(byte[] addr, int num, int macroNumber, int paramNumber, byte[] macroParam) throws ProtocolException {
        LcMacroParaResponse concreteBidibMessage = new LcMacroParaResponse(addr, num, macroNumber, paramNumber, macroParam);
        return concreteBidibMessage;
    }

    public BidibMessage createAccessoryStateResponse(byte[] addr, int num, int accessoryNumber, int aspect, byte[] value) throws ProtocolException {
        AccessoryStateResponse concreteBidibMessage = new AccessoryStateResponse(addr, num, accessoryNumber, aspect, value);
        return concreteBidibMessage;
    }

    public BidibMessage createAccessoryParaResponse(byte[] addr, int num, int accessoryNumber, int paramNumber, int[] accessoryParam) throws ProtocolException {
        AccessoryParaResponse concreteBidibMessage = new AccessoryParaResponse(addr, num, accessoryNumber, paramNumber, accessoryParam);
        return concreteBidibMessage;
    }
}

