/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;

public class BoostDiagnosticResponse
extends BidibMessage {
    public static final Integer TYPE = 178;

    BoostDiagnosticResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_BOOST_DIAGNOSTIC received.");
        }
    }

    public BoostDiagnosticResponse(byte[] addr, int num, int current, int voltage, int temperature) throws ProtocolException {
        this(addr, num, 178, 0, ByteUtils.getLowByte(current), 1, ByteUtils.getLowByte(voltage), 2, ByteUtils.getLowByte(temperature));
    }

    public BoostDiagnosticResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_BOOST_DIAGNOSTIC received");
        }
    }

    @Override
    public String getName() {
        return "MSG_BOOST_DIAGNOSTIC";
    }

    private int convertValue(int value) {
        int result = 0;
        if (value >= 1 && value <= 250) {
            result = value;
        }
        return result;
    }

    private byte getValue(int type) {
        byte result = 0;
        byte[] data = this.getData();
        for (int index = 0; index < data.length - 1; index += 2) {
            if (data[index] != type) continue;
            result = data[index + 1];
            break;
        }
        return result;
    }

    public int getCurrent() {
        return ConversionUtils.convertCurrent(this.getValue(0) & 0xFF);
    }

    public int getRawCurrent() {
        return ByteUtils.getInt(this.getValue(0));
    }

    public int getTemperature() {
        return ConversionUtils.convertTemperatureValue(this.getValue(2) & 0xFF);
    }

    public int getRawTemperature() {
        return ByteUtils.getInt(this.getValue(2));
    }

    public int getVoltage() {
        return ConversionUtils.convertVoltageValue(this.getValue(1) & 0xFF);
    }

    public int getRawVoltage() {
        return ByteUtils.getInt(this.getValue(1));
    }
}

