/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAcknowledge;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationAccessoryAcknowledgeResponse
extends BidibMessage {
    public static final Integer TYPE = 227;

    CommandStationAccessoryAcknowledgeResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_CS_ACCESSORY_ACK received");
        }
    }

    public CommandStationAccessoryAcknowledgeResponse(byte[] addr, int num, AddressData decoderAddress, byte acknowledge) throws ProtocolException {
        this(addr, num, (int)TYPE, CommandStationAccessoryAcknowledgeResponse.prepareData(decoderAddress, acknowledge));
    }

    public CommandStationAccessoryAcknowledgeResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_ACCESSORY_ACK";
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_CS_ACCESSORY_ACK received");
        }
    }

    private static byte[] prepareData(AddressData decoderAddress, byte acknowledge) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(decoderAddress.getAddress()));
        out.write(ByteUtils.getHighByte(decoderAddress.getAddress()));
        out.write(acknowledge);
        return out.toByteArray();
    }

    public int getAddress() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[0], data[1]);
    }

    public AccessoryAcknowledge getAcknState() {
        return AccessoryAcknowledge.valueOf(this.getData()[2]);
    }
}

