/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.ActivateCoilEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationAccessoryManualResponse
extends BidibMessage {
    public static final Integer TYPE = 231;
    private static final int DATA_INDEX = 2;

    CommandStationAccessoryManualResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_CS_ACCESSORY_MANUAL received.");
        }
    }

    public CommandStationAccessoryManualResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_CS_ACCESSORY_MANUAL received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_ACCESSORY_MANUAL";
    }

    public AddressData getDecoderAddress() {
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, highByte);
        byte data0 = this.getData()[2];
        AddressData addressData = new AddressData(address, (data0 & 0x80) == 128 ? AddressTypeEnum.EXTENDED_ACCESSORY : AddressTypeEnum.ACCESSORY);
        return addressData;
    }

    public ActivateCoilEnum getActivate() {
        byte type = (byte)((ByteUtils.getInt(this.getData()[2]) & 0x20) >> 5);
        return ActivateCoilEnum.valueOf(type);
    }

    public int getAspect() {
        return ByteUtils.getInt(this.getData()[2]) & 0x1F;
    }
}

