/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.ActivateCoilEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationAccessoryAcknowledgeResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationAccessoryMessage
extends BidibCommandMessage {
    public static final Integer TYPE = 101;
    private static final int DATA_INDEX = 2;
    private static final int TIME_INDEX = 3;

    public CommandStationAccessoryMessage(int address, AddressTypeEnum addressType, TimingControlEnum timingControl, ActivateCoilEnum activateCoil, int aspect, TimeBaseUnitEnum timeBaseUnit, int time) {
        super(0, 101, (byte)(address & 0xFF), (byte)((address & 0xFF00) >> 8), (byte)((AddressTypeEnum.ACCESSORY.equals(addressType) ? 0 : 1) << 7 | (TimingControlEnum.COIL_ON_OFF.equals(timingControl) ? 0 : 1) << 6 | (ActivateCoilEnum.COIL_OFF.equals(activateCoil) ? 0 : 1) << 5 | aspect & 0x1F), (byte)((TimeBaseUnitEnum.UNIT_100MS.equals(timeBaseUnit) ? 0 : 1) << 7 | time & 0x7F));
    }

    public CommandStationAccessoryMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_ACCESSORY";
    }

    public AddressData getDecoderAddress() {
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, highByte);
        byte data0 = this.getData()[2];
        AddressData addressData = new AddressData(address, (data0 & 0x80) == 128 ? AddressTypeEnum.EXTENDED_ACCESSORY : AddressTypeEnum.ACCESSORY);
        return addressData;
    }

    public TimingControlEnum getTimingControl() {
        return TimingControlEnum.valueOf((byte)((this.getData()[2] & 0x40) >> 6));
    }

    public ActivateCoilEnum getActivateCoil() {
        return ActivateCoilEnum.valueOf((byte)((this.getData()[2] & 0x20) >> 5));
    }

    public int getAspect() {
        return this.getData()[2] & 0x1F;
    }

    public int getTime() {
        return this.getData()[3] & 0x7F;
    }

    public TimeBaseUnitEnum getTimeBaseUnit() {
        return TimeBaseUnitEnum.valueOf((byte)((this.getData()[3] & 0x80) >> 7));
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationAccessoryAcknowledgeResponse.TYPE};
    }
}

