/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationBinaryStateMessage
extends BidibCommandMessage {
    public CommandStationBinaryStateMessage(int address, int stateNumber, boolean value) {
        super(0, 102, (byte)(address & 0xFF), (byte)((address & 0xFF00) >> 8), (byte)(stateNumber & 0xFF), (byte)((stateNumber & 0xFF00) >> 8), value ? (byte)1 : 0);
    }

    public CommandStationBinaryStateMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_BIN_STATE";
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationDriveAcknowledgeResponse.TYPE};
    }

    public AddressData getDecoderAddress() {
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, highByte);
        AddressTypeEnum addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_BACKWARD;
        AddressData addressData = new AddressData(address, addressTypeEnum);
        return addressData;
    }

    public int getBinaryStateNumber() {
        int index = 2;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int binStateNumber = ByteUtils.getWord(lowByte, highByte);
        return binStateNumber;
    }

    public int getBinaryStateValue() {
        int binStateValue = ByteUtils.getInt(this.getData()[4]);
        return binStateValue;
    }
}

