/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.DccATidData;
import org.bidib.jbidibc.messages.enums.DccAdvAcknowledge;
import org.bidib.jbidibc.messages.enums.DccAdvOpCodesAck;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationDccAdvAcknowledgeResponse
extends BidibMessage {
    public static final Integer TYPE = 235;

    CommandStationDccAdvAcknowledgeResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_CS_DCCA_ACK received.");
        }
    }

    public CommandStationDccAdvAcknowledgeResponse(byte[] addr, int num, DccATidData tid) throws ProtocolException {
        this(addr, num, 235, CommandStationDccAdvAcknowledgeResponse.prepareData(tid));
    }

    public CommandStationDccAdvAcknowledgeResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_CS_DCCA_ACK received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_DCCA_ACK";
    }

    private static byte[] prepareData(DccATidData tid) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(32));
        tid.writeToStream(out);
        return out.toByteArray();
    }

    public DccAdvOpCodesAck getOpCode() {
        return DccAdvOpCodesAck.valueOf(this.getData()[0]);
    }

    public DccATidData getTid() {
        byte[] data = this.getData();
        if (DccAdvOpCodesAck.BIDIB_DCCA_TID != this.getOpCode()) {
            return null;
        }
        return DccATidData.fromByteArray(data, 1);
    }

    public DccAdvAcknowledge getAcknState() {
        DccAdvAcknowledge dccAdvAcknowledge = DccAdvAcknowledge.valueOf(this.getData()[1]);
        return dccAdvAcknowledge;
    }

    public Integer getIndex() {
        byte[] data = this.getData();
        switch (this.getOpCode()) {
            case BIDIB_DCCA_SELECT_INFO_SHORTGUI: 
            case BIDIB_DCCA_SELECT_INFO_SHORTINFO: 
            case BIDIB_DCCA_SELECT_INFO_FIRMWARE_ID: 
            case BIDIB_DCCA_SELECT_INFO_FULLNAME: 
            case BIDIB_DCCA_SELECT_INFO_FUNCMAP: 
            case BIDIB_DCCA_SELECT_INFO_PICINFO: 
            case BIDIB_DCCA_SELECT_INFO_PRODUCTNAME: 
            case BIDIB_DCCA_SELECT_INFO_RAILCOMPAGE: 
            case BIDIB_DCCA_SELECT_INFO_SHORTNAME: 
            case BIDIB_DCCA_SELECT_INFO_CVp0: 
            case BIDIB_DCCA_SELECT_INFO_CVp1: {
                break;
            }
            default: {
                return null;
            }
        }
        return ByteUtils.getInt(data[1]);
    }
}

