/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.DccATidData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.enums.DccAdvOpCodes;
import org.bidib.jbidibc.messages.enums.DccAdvSelectInfoOpCode;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationDccAdvAcknowledgeResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationDccAdvMessage
extends BidibCommandMessage {
    public CommandStationDccAdvMessage(DccAdvOpCodes opCode) {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, (byte[])null));
    }

    public CommandStationDccAdvMessage(DccAdvOpCodes opCode, byte[] data) {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, data));
    }

    public CommandStationDccAdvMessage(DccAdvOpCodes opCode, DccATidData tid) {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, tid));
    }

    public CommandStationDccAdvMessage(DccAdvOpCodes opCode, int repetitions, int interval) {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, repetitions, interval));
    }

    public CommandStationDccAdvMessage(DccAdvOpCodes opCode, int repetitions) {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, repetitions));
    }

    public CommandStationDccAdvMessage(DccAdvOpCodes opCode, DecoderUniqueIdData did, int address) throws ProtocolException {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, did, address));
    }

    public CommandStationDccAdvMessage(DccAdvOpCodes opCode, DecoderUniqueIdData did, DccAdvSelectInfoOpCode selectInfoOpCode) throws ProtocolException {
        super(0, 107, CommandStationDccAdvMessage.prepareData(opCode, did, selectInfoOpCode));
    }

    public CommandStationDccAdvMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_DCCA";
    }

    private static byte[] prepareData(DccAdvOpCodes opCode, int repetitions, int interval) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        out.write(ByteUtils.getLowByte(repetitions));
        out.write(ByteUtils.getLowByte(interval));
        return out.toByteArray();
    }

    private static byte[] prepareData(DccAdvOpCodes opCode, int repetitions) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        out.write(ByteUtils.getLowByte(repetitions));
        return out.toByteArray();
    }

    private static byte[] prepareData(DccAdvOpCodes opCode, DccATidData tid) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        if (tid != null) {
            tid.writeToStream(out);
        }
        return out.toByteArray();
    }

    private static byte[] prepareData(DccAdvOpCodes opCode, DecoderUniqueIdData did, int address) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        if (did == null) {
            throw new ProtocolException("No DID data provided.");
        }
        did.writeToStream(out);
        out.write(ByteUtils.getLowByte(address));
        out.write(ByteUtils.getHighByte(address));
        return out.toByteArray();
    }

    private static byte[] prepareData(DccAdvOpCodes opCode, DecoderUniqueIdData did, DccAdvSelectInfoOpCode selectInfoOpCode) throws ProtocolException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        if (did == null) {
            throw new ProtocolException("No DID data provided.");
        }
        did.writeToStream(out);
        out.write(selectInfoOpCode.getType());
        return out.toByteArray();
    }

    private static byte[] prepareData(DccAdvOpCodes opCode, byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        if (data != null) {
            out.write(data, 0, data.length);
        }
        return out.toByteArray();
    }

    public DccAdvOpCodes getOpCode() {
        byte opCode = this.getData()[0];
        return DccAdvOpCodes.valueOf(opCode);
    }

    public TidData getTid() {
        TidData tid = TidData.fromByteArray(this.getData(), 1);
        return tid;
    }

    public DecoderUniqueIdData getDid() throws ProtocolException {
        DecoderUniqueIdData did = null;
        switch (this.getOpCode()) {
            case BIDIB_DCCA_LOGON_ASSIGN: {
                did = DecoderUniqueIdData.fromByteArray(this.getData(), 1);
                break;
            }
            case BIDIB_DCCA_SELECT_INFO: {
                did = DecoderUniqueIdData.fromByteArray(this.getData(), 1);
                break;
            }
            default: {
                throw new ProtocolException("The opCode is not BIDIB_DCCA_LOGON_ASSIGN: " + this.getOpCode());
            }
        }
        return did;
    }

    public DccAdvSelectInfoOpCode getInfoOpCode() throws ProtocolException {
        if (DccAdvOpCodes.BIDIB_DCCA_SELECT_INFO != this.getOpCode()) {
            throw new ProtocolException("The opCode is not BIDIB_DCCA_GET_INFO: " + this.getOpCode());
        }
        return DccAdvSelectInfoOpCode.valueOf(this.getData()[6]);
    }

    public int getAssignedAddress() throws ProtocolException {
        if (DccAdvOpCodes.BIDIB_DCCA_LOGON_ASSIGN != this.getOpCode()) {
            throw new ProtocolException("The opCode is not BIDIB_DCCA_LOGON_ASSIGN: " + this.getOpCode());
        }
        return ByteUtils.toInt(this.getData()[7], this.getData()[6]);
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationDccAdvAcknowledgeResponse.TYPE};
    }

    public int getRepetitions() throws ProtocolException {
        if (DccAdvOpCodes.BIDIB_DCCA_GET_DATA != this.getOpCode()) {
            throw new ProtocolException("The opCode is not BIDIB_DCCA_GET_DATA: " + this.getOpCode());
        }
        return ByteUtils.getInt(this.getData()[1]);
    }
}

