/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.DriveAcknowledge;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationDriveAcknowledgeResponse
extends BidibMessage {
    public static final Integer TYPE = 226;

    public CommandStationDriveAcknowledgeResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_CS_DRIVE_ACK received");
        }
    }

    public CommandStationDriveAcknowledgeResponse(byte[] addr, int num, AddressData decoderAddress, byte acknowledge, Integer acknowledgedMessageNumber) throws ProtocolException {
        this(addr, num, 226, CommandStationDriveAcknowledgeResponse.prepareData(decoderAddress, acknowledge, acknowledgedMessageNumber));
    }

    public CommandStationDriveAcknowledgeResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_CS_DRIVE_ACK received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_DRIVE_ACK";
    }

    private static byte[] prepareData(AddressData decoderAddress, byte acknowledge, Integer acknowledgedMessageNumber) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(decoderAddress.getAddress()));
        out.write(ByteUtils.getHighByte(decoderAddress.getAddress()));
        out.write(acknowledge);
        if (acknowledgedMessageNumber != null) {
            out.write(ByteUtils.getLowByte(acknowledgedMessageNumber).byteValue());
        }
        return out.toByteArray();
    }

    public int getDccAddress() {
        byte[] data = this.getData();
        return (data[0] & 0xFF) + ((data[1] & 0x3F) << 8);
    }

    public DriveAcknowledge getState() {
        return DriveAcknowledge.valueOf(this.getData()[2]);
    }

    public Integer getAcknowledgedMessageNumber() {
        if (this.getData().length > 3) {
            return this.getData()[3] & 0xFF;
        }
        return null;
    }
}

