/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationDriveManualResponse
extends BidibMessage {
    public static final Integer TYPE = 229;
    public static final int FUNCTIONS_INDEX_F0_F4 = 0;
    public static final int FUNCTIONS_INDEX_F5_F12 = 1;
    public static final int FUNCTIONS_INDEX_F13_F20 = 2;
    public static final int FUNCTIONS_INDEX_F21_F28 = 3;

    public CommandStationDriveManualResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 9) {
            throw new ProtocolException("No valid MSG_CS_DRIVE_MANUAL received.");
        }
    }

    public CommandStationDriveManualResponse(byte[] addr, int num, DriveState driveState) throws ProtocolException {
        this(addr, num, 229, CommandStationDriveManualResponse.prepareData(driveState));
    }

    public CommandStationDriveManualResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 9) {
            throw new ProtocolException("No valid MSG_CS_DRIVE_MANUAL received");
        }
    }

    private static byte[] prepareData(DriveState driveState) {
        AddressData decoderAddress = new AddressData(driveState.getAddress(), driveState.getDirection() == DirectionEnum.FORWARD ? AddressTypeEnum.LOCOMOTIVE_FORWARD : AddressTypeEnum.LOCOMOTIVE_BACKWARD);
        SpeedStepsEnum speedSteps = SpeedStepsEnum.valueOf(ByteUtils.getLowByte(driveState.getAddressFormat()));
        int speed = driveState.getSpeed();
        byte[] functions = driveState.getFunctions();
        return CommandStationDriveManualResponse.prepareData(decoderAddress, speedSteps, speed, functions);
    }

    private static byte[] prepareData(AddressData decoderAddress, SpeedStepsEnum speedSteps, int speed, byte[] functions) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        decoderAddress.writeToStream(out);
        out.write(speedSteps.getType());
        out.write(1);
        out.write(ByteUtils.getLowByte(speed));
        out.write(functions, 0, functions.length);
        return out.toByteArray();
    }

    @Override
    public String getName() {
        return "MSG_CS_DRIVE_MANUAL";
    }

    public int getAddress() {
        byte[] data = this.getData();
        return (data[0] & 0xFF) + ((data[1] & 0xFF) << 8);
    }

    public byte getFormat() {
        return this.getData()[2];
    }

    public byte getOutputActive() {
        return this.getData()[3];
    }

    public int getSpeed() {
        return ByteUtils.getInt(this.getData()[4]);
    }

    public byte getLights() {
        return (byte)(this.getData()[5] & 0x10);
    }

    public byte getFunctions(int index) {
        return this.getData()[5 + index];
    }

    public DriveState getDriveState() {
        DriveState driveState = new DriveState(this.getAddress(), ByteUtils.getInt(this.getData()[2]), ByteUtils.getInt(this.getData()[3]), this.getSpeed(), ByteUtils.getInt(this.getLights()));
        byte[] functions = new byte[4];
        for (int index = 0; index < 4; ++index) {
            functions[index] = this.getFunctions(index);
        }
        driveState.setFunctions(functions);
        return driveState;
    }
}

