/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.util.BitSet;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveAcknowledgeResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;

public class CommandStationDriveMessage
extends BidibCommandMessage {
    public CommandStationDriveMessage(int address, SpeedStepsEnum speedSteps, Integer speed, DirectionEnum direction, BitSet activeFunctions, BitSet functions) {
        super(0, 100, ByteUtils.concat(new byte[]{(byte)(address & 0xFF), (byte)((address & 0xFF00) >> 8), speedSteps.getType(), ConversionUtils.getOutputFunctionBits(speed, activeFunctions), ConversionUtils.convertSpeed(speed, direction)}, ConversionUtils.convertFunctions(functions)));
    }

    public CommandStationDriveMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_DRIVE";
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationDriveAcknowledgeResponse.TYPE};
    }

    public AddressData getDecoderAddress() {
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, highByte);
        byte data2 = this.getData()[index += 2];
        AddressTypeEnum addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_BACKWARD;
        if ((data2 & 0x80) == 128) {
            addressTypeEnum = AddressTypeEnum.LOCOMOTIVE_FORWARD;
        }
        AddressData addressData = new AddressData(address, addressTypeEnum);
        return addressData;
    }

    public SpeedStepsEnum getSpeedSteps() {
        return SpeedStepsEnum.valueOf(this.getData()[2]);
    }

    public int getOutputActiveBits() {
        int outputActiveBits = this.getData()[3] & 0xFF;
        return outputActiveBits;
    }

    public int getSpeed() {
        int speed = this.getData()[4] & 0x7F;
        return speed;
    }

    public int[] getFunctionBits() {
        int functionBitsF0F4 = this.getData()[5] & 0xFF;
        int functionBitsF5F12 = this.getData()[6] & 0xFF;
        int functionBitsF13F20 = this.getData()[7] & 0xFF;
        int functionBitsF21F28 = this.getData()[8] & 0xFF;
        return new int[]{functionBitsF0F4, functionBitsF5F12, functionBitsF13F20, functionBitsF21F28};
    }

    public byte getFunctions(int index) {
        return this.getData()[5 + index];
    }

    public int getAddress() {
        byte[] data = this.getData();
        return (data[0] & 0xFF) + ((data[1] & 0xFF) << 8);
    }

    public byte getLights() {
        return (byte)(this.getData()[5] & 0x10);
    }

    public DriveState getDriveState() {
        DriveState driveState = new DriveState(this.getAddress(), ByteUtils.getInt(this.getData()[2]), ByteUtils.getInt(this.getData()[3]), (int)this.getData()[4], ByteUtils.getInt(this.getLights()));
        byte[] functions = new byte[4];
        for (int index = 0; index < 4; ++index) {
            functions[index] = this.getFunctions(index);
        }
        driveState.setFunctions(functions);
        return driveState;
    }
}

