/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DriveState;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.DirectionEnum;
import org.bidib.jbidibc.messages.enums.SpeedStepsEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationDriveStateResponse
extends BidibMessage {
    public static final Integer TYPE = 234;

    public CommandStationDriveStateResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 4) {
            throw new ProtocolException("No valid MSG_CS_DRIVE_STATE received. Expected more than length: " + (Serializable)(data != null ? Integer.valueOf(data.length) : "0"));
        }
    }

    public CommandStationDriveStateResponse(byte[] addr, int num, int opCode, AddressData decoderAddress, SpeedStepsEnum speedSteps, int speed, byte[] functions) throws ProtocolException {
        this(addr, num, 234, CommandStationDriveStateResponse.prepareData(opCode, decoderAddress, speedSteps, speed, functions, new byte[0]));
    }

    public CommandStationDriveStateResponse(byte[] addr, int num, int opCode, DriveState driveState) throws ProtocolException {
        this(addr, num, 234, CommandStationDriveStateResponse.prepareData(opCode, driveState, new byte[0]));
    }

    public CommandStationDriveStateResponse(byte[] addr, int num, int opCode, DriveState driveState, byte ... optionalData) throws ProtocolException {
        this(addr, num, 234, CommandStationDriveStateResponse.prepareData(opCode, driveState, optionalData));
    }

    public CommandStationDriveStateResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 4) {
            throw new ProtocolException("No valid MSG_CS_DRIVE_STATE received. Expected more than length: " + (Serializable)(this.getData() != null ? Integer.valueOf(this.getData().length) : "0"));
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_DRIVE_STATE";
    }

    private static byte[] prepareData(int opCode, DriveState driveState, byte ... optionalData) {
        AddressData decoderAddress = new AddressData(driveState.getAddress(), driveState.getDirection() == DirectionEnum.FORWARD ? AddressTypeEnum.LOCOMOTIVE_FORWARD : AddressTypeEnum.LOCOMOTIVE_BACKWARD);
        SpeedStepsEnum speedSteps = SpeedStepsEnum.valueOf(ByteUtils.getLowByte(driveState.getAddressFormat()));
        int speed = driveState.getSpeed();
        byte[] functions = driveState.getFunctions();
        return CommandStationDriveStateResponse.prepareData(opCode, decoderAddress, speedSteps, speed, functions, optionalData);
    }

    private static byte[] prepareData(int opCode, AddressData decoderAddress, SpeedStepsEnum speedSteps, int speed, byte[] functions, byte ... optionalData) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(opCode));
        decoderAddress.writeToStream(out);
        out.write(speedSteps.getType());
        out.write(1);
        out.write(ByteUtils.getLowByte(speed));
        out.write(functions, 0, functions.length);
        if (optionalData != null) {
            out.write(optionalData, 0, optionalData.length);
        }
        return out.toByteArray();
    }

    public byte getOpCode() {
        return this.getData()[0];
    }

    public int getDecoderAddress() {
        byte[] data = this.getData();
        return (data[1] & 0xFF) + ((data[2] & 0xFF) << 8);
    }

    public byte getFormat() {
        return this.getData()[3];
    }

    public byte getOutputActive() {
        return this.getData()[4];
    }

    public int getSpeed() {
        return ByteUtils.getInt(this.getData()[5]);
    }

    public byte getLights() {
        return (byte)(this.getData()[6] & 0x10);
    }

    public byte getFunctions(int index) {
        return this.getData()[6 + index];
    }

    public DriveState getDriveState() {
        DriveState driveState = new DriveState(this.getDecoderAddress(), ByteUtils.getInt(this.getData()[3]), ByteUtils.getInt(this.getData()[4]), this.getSpeed(), ByteUtils.getInt(this.getLights()));
        byte[] functions = new byte[4];
        for (int index = 0; index < 4; ++index) {
            functions[index] = this.getFunctions(index);
        }
        driveState.setFunctions(functions);
        return driveState;
    }

    public byte[] getOptionalData() {
        if (this.getData().length > 10) {
            return ByteUtils.subArray(this.getData(), 10);
        }
        return null;
    }
}

