/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.enums.M4OpCodesAck;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationM4AcknowledgeResponse
extends BidibMessage {
    public static final Integer TYPE = 233;

    CommandStationM4AcknowledgeResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_CS_M4_ACK received.");
        }
    }

    public CommandStationM4AcknowledgeResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_CS_M4_ACK received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_M4_ACK";
    }

    public M4OpCodesAck getOpCode() {
        return M4OpCodesAck.valueOf(this.getData()[0]);
    }

    public TidData getTid() {
        byte[] data = this.getData();
        if (!M4OpCodesAck.M4_TID.equals(this.getOpCode())) {
            return null;
        }
        return TidData.fromByteArray(data, 1);
    }

    public Integer getInterval(M4OpCodesAck expectedOpCode) {
        byte[] data = this.getData();
        if (!expectedOpCode.equals(this.getOpCode())) {
            return null;
        }
        Integer beaconInterval = ByteUtils.getInt(data[1]);
        return beaconInterval;
    }

    public Integer getDid(M4OpCodesAck expectedOpCode) {
        if (!expectedOpCode.equals(this.getOpCode())) {
            return null;
        }
        byte[] data = this.getData();
        int value = 0;
        for (int index = 1; index < 5; ++index) {
            value = value << 8 | data[index] & 0xFF;
        }
        return value;
    }
}

