/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.enums.M4OpCodes;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationM4AcknowledgeResponse;

public class CommandStationM4Message
extends BidibCommandMessage {
    public CommandStationM4Message(M4OpCodes opCode) {
        super(0, 105, opCode.getType());
    }

    public CommandStationM4Message(M4OpCodes opCode, byte[] data) {
        super(0, 105, CommandStationM4Message.prepareData(opCode, data));
    }

    public CommandStationM4Message(M4OpCodes opCode, TidData tid) {
        super(0, 105, CommandStationM4Message.prepareData(opCode, tid));
    }

    public CommandStationM4Message(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_M4";
    }

    public M4OpCodes getOpCode() {
        byte opCode = this.getData()[0];
        return M4OpCodes.valueOf(opCode);
    }

    public TidData getTid() {
        TidData tid = TidData.fromByteArray(this.getData(), 1);
        return tid;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationM4AcknowledgeResponse.TYPE};
    }

    private static byte[] prepareData(M4OpCodes opCode, byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        if (data != null) {
            out.write(data, 0, data.length);
        }
        return out.toByteArray();
    }

    private static byte[] prepareData(M4OpCodes opCode, TidData tid) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        if (tid != null) {
            tid.writeToStream(out);
        }
        return out.toByteArray();
    }
}

