/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomAcknowledge;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationPomAcknowledgeResponse
extends BidibMessage {
    public static final Integer TYPE = 228;

    CommandStationPomAcknowledgeResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 6) {
            throw new ProtocolException("No valid MSG_CS_POM_ACK received.");
        }
    }

    public CommandStationPomAcknowledgeResponse(byte[] addr, int num, PomAddressData decoderAddress, byte acknowledge) throws ProtocolException {
        this(addr, num, 228, CommandStationPomAcknowledgeResponse.prepareData(decoderAddress, acknowledge));
    }

    public CommandStationPomAcknowledgeResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 6) {
            throw new ProtocolException("No valid MSG_CS_POM_ACK received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_POM_ACK";
    }

    private static byte[] prepareData(PomAddressData decoderAddress, byte acknowledge) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        decoderAddress.writeToStream(out);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(acknowledge);
        return out.toByteArray();
    }

    public PomAddressData getAddress() {
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        PomAddressData addressData = new PomAddressData(address, PomAddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
        return addressData;
    }

    public int getAddressX() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[2], data[3]);
    }

    public int getMID() {
        return ByteUtils.getInt(this.getData()[4]);
    }

    public PomAcknowledge getAcknState() {
        return PomAcknowledge.valueOf(this.getData()[5]);
    }
}

