/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.DecoderIdAddressData;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.CommandStationPom;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationPomAcknowledgeResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationPomMessage
extends BidibCommandMessage {
    public CommandStationPomMessage(PomAddressData decoderAddress, CommandStationPom opCode, int cvNumber) {
        super(0, 103, CommandStationPomMessage.prepareData(decoderAddress, opCode, cvNumber, null));
    }

    public CommandStationPomMessage(PomAddressData decoderAddress, CommandStationPom opCode, int cvNumber, byte[] data) {
        super(0, 103, CommandStationPomMessage.prepareData(decoderAddress, opCode, cvNumber, data));
    }

    public CommandStationPomMessage(DecoderIdAddressData addressDID, CommandStationPom opCode, int cvNumber, byte[] data) {
        super(0, 103, CommandStationPomMessage.prepareData(addressDID, opCode, cvNumber, data));
    }

    public CommandStationPomMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_POM";
    }

    private static byte[] prepareData(PomAddressData decoderAddress, CommandStationPom opCode, int cvNumber, byte[] data) {
        boolean xpom = false;
        if (opCode.ordinal() > CommandStationPom.WR_BYTE.ordinal()) {
            if (cvNumber < 1 || cvNumber > 0xFFFFFF) {
                throw new IllegalArgumentException("CV number is out of allowed range (1..16777215): " + cvNumber);
            }
            xpom = true;
        } else if (cvNumber < 1 || cvNumber > 1024) {
            throw new IllegalArgumentException("CV number is out of allowed range (1..1024): " + cvNumber);
        }
        if (data != null && data.length > 4) {
            throw new IllegalArgumentException("Maximum 4 bytes data are allowed.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        decoderAddress.writeToStream(out);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(opCode.getType());
        if (!CommandStationPom.XWR_BYTE2.equals(opCode)) {
            out.write(ByteUtils.getLowByte(cvNumber - 1));
            out.write(ByteUtils.getHighByte(cvNumber - 1));
        } else {
            out.write(ByteUtils.getLowByte(cvNumber));
            out.write(ByteUtils.getHighByte(cvNumber));
        }
        if (xpom) {
            out.write(ByteUtils.getHighWordLowByte(cvNumber - 1));
        } else {
            out.write(0);
        }
        if (data != null && data.length > 0) {
            out.write(data, 0, data.length);
        }
        return out.toByteArray();
    }

    private static byte[] prepareData(DecoderIdAddressData addressDID, CommandStationPom opCode, int cvNumber, byte[] data) {
        boolean xpom = false;
        if (opCode.ordinal() > CommandStationPom.WR_BYTE.ordinal()) {
            if (cvNumber < 1 || cvNumber > 0xFFFFFF) {
                throw new IllegalArgumentException("CV number is out of allowed range (1..16777215): " + cvNumber);
            }
            xpom = true;
        } else if (cvNumber < 1 || cvNumber > 1024) {
            throw new IllegalArgumentException("CV number is out of allowed range (1..1024): " + cvNumber);
        }
        if (data != null && data.length > 4) {
            throw new IllegalArgumentException("Maximum 4 bytes data are allowed.");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        addressDID.writeToStream(out);
        out.write(opCode.getType());
        out.write(ByteUtils.getLowByte(cvNumber - 1));
        out.write(ByteUtils.getHighByte(cvNumber - 1));
        if (xpom) {
            out.write(ByteUtils.getHighWordLowByte(cvNumber - 1));
        } else {
            out.write(0);
        }
        if (data != null && data.length > 0) {
            out.write(data, 0, data.length);
        }
        return out.toByteArray();
    }

    public PomAddressData getDecoderAddress() {
        int index = 0;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        PomAddressData addressData = new PomAddressData(address, PomAddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
        return addressData;
    }

    public int getAddressX() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[2], data[3]);
    }

    public int getMid() {
        int opCode = ByteUtils.getInt(this.getData()[4]);
        return opCode;
    }

    public int getOpCode() {
        int opCode = ByteUtils.getInt(this.getData()[5]);
        return opCode;
    }

    public int getCvNumber() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[6], data[7]) + 1;
    }

    public int getCvNumberX() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[8]);
    }

    public int getCvValue() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[9]);
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationPomAcknowledgeResponse.TYPE};
    }
}

