/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.enums.CommandStationPt;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationProgMessage
extends BidibCommandMessage {
    @Deprecated(forRemoval=true)
    public CommandStationProgMessage(CommandStationPt opCode, int cvNumber, byte data) {
        super(0, 111, CommandStationProgMessage.prepareData(opCode, cvNumber, ByteUtils.getInt(data)));
    }

    public CommandStationProgMessage(CommandStationPt opCode, int cvNumber, int data) {
        super(0, 111, CommandStationProgMessage.prepareData(opCode, cvNumber, data));
    }

    public CommandStationProgMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_PROG";
    }

    private static byte[] prepareData(CommandStationPt opCode, int cvNumber, int data) {
        if (cvNumber < 1 || cvNumber > 1024) {
            throw new IllegalArgumentException("CV number is out of allowed range (1..1024).");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(opCode.getType());
        out.write(ByteUtils.getLowByte(cvNumber - 1));
        out.write(ByteUtils.getHighByte(cvNumber - 1));
        out.write(ByteUtils.getLowByte(data));
        return out.toByteArray();
    }

    public CommandStationPt getOpCode() {
        byte opCode = this.getData()[0];
        CommandStationPt commandStationPt = CommandStationPt.valueOf(opCode);
        return commandStationPt;
    }

    public int getCvNumber() {
        int index = 1;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int cvNumber = ByteUtils.getWord(lowByte, highByte);
        return ++cvNumber;
    }

    public int getCvData() {
        if (this.getData().length > 3) {
            byte cvData = this.getData()[3];
            return ByteUtils.getInt(cvData);
        }
        return -1;
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }
}

