/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.enums.CommandStationProgState;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationProgStateResponse
extends BidibMessage {
    public static final Integer TYPE = 239;

    CommandStationProgStateResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 4) {
            throw new ProtocolException("No valid MSG_CS_PROG_STATE received.");
        }
    }

    public CommandStationProgStateResponse(byte[] addr, int num, CommandStationProgState state, int remainingTime, int cvNumber, int cvData) throws ProtocolException {
        this(addr, num, 239, CommandStationProgStateResponse.prepareData(state, remainingTime, cvNumber, cvData));
    }

    public CommandStationProgStateResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 4) {
            throw new ProtocolException("No valid MSG_CS_PROG_STATE received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_PROG_STATE";
    }

    private static byte[] prepareData(CommandStationProgState state, int remainingTime, int cvNumber, int cvData) {
        if (cvNumber < 1 || cvNumber > 1024) {
            throw new IllegalArgumentException("CV number is out of allowed range (1..1024).");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(state.getType());
        out.write(ByteUtils.getLowByte(remainingTime));
        out.write(ByteUtils.getLowByte(cvNumber - 1));
        out.write(ByteUtils.getHighByte(cvNumber - 1));
        out.write(ByteUtils.getLowByte(cvData));
        return out.toByteArray();
    }

    public CommandStationProgState getState() {
        return CommandStationProgState.valueOf(this.getData()[0]);
    }

    public int getRemainingTime() {
        return ByteUtils.getInt(this.getData()[1]);
    }

    public int getCvNumber() {
        int index = 2;
        byte lowByte = this.getData()[index++];
        byte highByte = this.getData()[index++];
        int cvNumber = ByteUtils.getWord(lowByte, highByte);
        return ++cvNumber;
    }

    public int getCvData() {
        if (this.getData().length > 4) {
            byte cvData = this.getData()[4];
            return ByteUtils.getInt(cvData);
        }
        return -1;
    }
}

