/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.enums.CsQueryTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.message.CommandStationDriveStateResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationQueryMessage
extends BidibCommandMessage {
    public CommandStationQueryMessage(CsQueryTypeEnum queryType) {
        super(0, 106, ByteUtils.setBit(queryType.getType(), true, 7));
    }

    public CommandStationQueryMessage(CsQueryTypeEnum queryType, int param) {
        super(0, 106, ByteUtils.concat(new byte[]{queryType.getType()}, ByteUtils.toWORD(param)));
    }

    public CommandStationQueryMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_CS_QUERY";
    }

    public CsQueryTypeEnum getCsQueryType() {
        byte csQueryType = this.getData()[0];
        return CsQueryTypeEnum.valueOf(ByteUtils.getLowByte(csQueryType & 0x7F));
    }

    public byte getCsQueryValue() {
        return this.getData()[0];
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return new Integer[]{CommandStationDriveStateResponse.TYPE};
    }
}

