/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.RcPlusDecoderAnswerData;
import org.bidib.jbidibc.messages.TidData;
import org.bidib.jbidibc.messages.enums.RcPlusAcknowledge;
import org.bidib.jbidibc.messages.enums.RcPlusOpCodesAck;
import org.bidib.jbidibc.messages.enums.RcPlusPhase;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class CommandStationRcPlusAcknowledgeResponse
extends BidibMessage {
    public static final Integer TYPE = 232;

    CommandStationRcPlusAcknowledgeResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_CS_RCPLUS_ACK received.");
        }
    }

    public CommandStationRcPlusAcknowledgeResponse(byte[] addr, int num, TidData tid) throws ProtocolException {
        this(addr, num, 232, CommandStationRcPlusAcknowledgeResponse.prepareData(tid));
    }

    public CommandStationRcPlusAcknowledgeResponse(byte[] addr, int num, RcPlusPhase phase, int pingOnceData) throws ProtocolException {
        this(addr, num, 232, CommandStationRcPlusAcknowledgeResponse.prepareData(phase, pingOnceData));
    }

    public CommandStationRcPlusAcknowledgeResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_CS_RCPLUS_ACK received");
        }
    }

    @Override
    public String getName() {
        return "MSG_CS_RCPLUS_ACK";
    }

    private static byte[] prepareData(TidData tid) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(RcPlusOpCodesAck.RC_TID.getType());
        tid.writeToStream(out);
        return out.toByteArray();
    }

    private static byte[] prepareData(RcPlusPhase phase, int pingOnceData) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(RcPlusPhase.P0 == phase ? RcPlusOpCodesAck.RC_PING_ONCE_P0.getType() : RcPlusOpCodesAck.RC_PING_ONCE_P1.getType());
        out.write(ByteUtils.getLowByte(pingOnceData));
        return out.toByteArray();
    }

    public RcPlusOpCodesAck getOpCode() {
        return RcPlusOpCodesAck.valueOf(this.getData()[0]);
    }

    public TidData getTid() {
        byte[] data = this.getData();
        if (!RcPlusOpCodesAck.RC_TID.equals(this.getOpCode())) {
            return null;
        }
        return TidData.fromByteArray(data, 1);
    }

    public RcPlusAcknowledge getAcknState() {
        RcPlusAcknowledge rcPlusAcknowledge = RcPlusAcknowledge.valueOf(this.getData()[1]);
        return rcPlusAcknowledge;
    }

    public int getPingInterval() {
        if (!RcPlusOpCodesAck.RC_PING.equals(this.getOpCode())) {
            return 0;
        }
        int pingInterval = ByteUtils.getInt(this.getData()[1]);
        return pingInterval;
    }

    public RcPlusDecoderAnswerData getRcPlusDecoderAnswer() {
        byte[] data = this.getData();
        RcPlusDecoderAnswerData answerData = null;
        switch (this.getOpCode()) {
            case RC_BIND: 
            case RC_FIND_P0: 
            case RC_FIND_P1: {
                answerData = RcPlusDecoderAnswerData.fromByteArray(data, 1);
                break;
            }
        }
        return answerData;
    }
}

