/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeatureCountResponse
extends BidibMessage {
    public static final Integer TYPE = 146;

    FeatureCountResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_FEATURE_COUNT received.");
        }
    }

    public FeatureCountResponse(byte[] addr, int num, int featureCount) throws ProtocolException {
        super(addr, num, 146, ByteUtils.getLowByte(featureCount));
    }

    public FeatureCountResponse(byte[] addr, int num, int featureCount, int streamingSupported) throws ProtocolException {
        this(addr, num, 146, ByteUtils.getLowByte(featureCount), ByteUtils.getLowByte(streamingSupported));
    }

    public FeatureCountResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_FEATURE_COUNT received");
        }
    }

    @Override
    public String getName() {
        return "MSG_FEATURE_COUNT";
    }

    public int getCount() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public boolean isStreamingSupported() {
        if (this.getData().length > 1) {
            return ByteUtils.getInt(this.getData()[1]) == 1;
        }
        return false;
    }
}

