/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeatureNotAvailableResponse
extends BidibMessage {
    public static final Integer TYPE = 145;

    FeatureNotAvailableResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_FEATURE_NA received.");
        }
    }

    public FeatureNotAvailableResponse(byte[] addr, int num, int featureNum) throws ProtocolException {
        this(addr, num, 145, ByteUtils.getLowByte(featureNum));
    }

    public FeatureNotAvailableResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_FEATURE_NA received");
        }
    }

    @Override
    public String getName() {
        return "MSG_FEATURE_NA";
    }

    public int getFeatureNumber() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public FeatureEnum getFeature() {
        FeatureEnum feature = null;
        byte number = this.getData()[0];
        try {
            feature = FeatureEnum.valueOf(number);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return feature;
    }
}

