/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeatureResponse
extends BidibMessage {
    public static final Integer TYPE = 144;

    FeatureResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_FEATURE received.");
        }
    }

    public FeatureResponse(byte[] addr, int num, int featureNum, int featureValue) throws ProtocolException {
        this(addr, num, 144, ByteUtils.getLowByte(featureNum), ByteUtils.getLowByte(featureValue));
    }

    public FeatureResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_FEATURE received");
        }
    }

    @Override
    public String getName() {
        return "MSG_FEATURE";
    }

    public Feature getFeature() {
        byte[] data = this.getData();
        return new Feature(ByteUtils.getInt(data[0]), ByteUtils.getInt(data[1]));
    }
}

