/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackAccessoryResponse
extends BidibMessage {
    public static final Integer TYPE = 164;

    FeedbackAccessoryResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_BM_ACCESSORY received.");
        }
    }

    public FeedbackAccessoryResponse(byte[] addr, int num, int detectorNumber, int address) throws ProtocolException {
        this(addr, num, 164, FeedbackAccessoryResponse.prepareAddressData(detectorNumber, address));
    }

    public FeedbackAccessoryResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_BM_ACCESSORY received");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_ACCESSORY";
    }

    public int getDetectorNumber() {
        return ByteUtils.getInt(this.getData()[0], 127);
    }

    private static byte[] prepareAddressData(int detectorNumber, int address) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(detectorNumber));
        out.write(ByteUtils.getLowByte(address));
        out.write(ByteUtils.getHighByte(address) & 0x3F);
        return out.toByteArray();
    }

    public int getAddress() {
        byte[] data = this.getData();
        int index = 1;
        byte lowByte = data[index++];
        byte highByte = data[index++];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        return address;
    }
}

