/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import java.util.List;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackAddressResponse
extends BidibMessage {
    public static final Integer TYPE = 163;

    FeedbackAddressResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_BM_ADDRESS received.");
        }
    }

    public FeedbackAddressResponse(byte[] addr, int num, int detectorNumber, List<AddressData> addresses) throws ProtocolException {
        this(addr, num, 163, FeedbackAddressResponse.prepareAddressData(detectorNumber, addresses));
    }

    public FeedbackAddressResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_BM_ADDRESS received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_ADDRESS";
    }

    public int getDetectorNumber() {
        int dectectorNumber = ByteUtils.getInt(this.getData()[0]);
        if (dectectorNumber < 255) {
            return ByteUtils.getInt(dectectorNumber, 127);
        }
        return dectectorNumber;
    }

    private static byte[] prepareAddressData(int detectorNumber, List<AddressData> addresses) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(detectorNumber));
        if (addresses.size() > 0) {
            for (AddressData addressData : addresses) {
                addressData.writeToStream(out);
            }
        } else {
            out.write(0);
            out.write(0);
        }
        return out.toByteArray();
    }

    public List<AddressData> getAddresses() {
        LinkedList<AddressData> result = new LinkedList<AddressData>();
        byte[] data = this.getData();
        int index = 1;
        while (index < data.length) {
            byte highByte;
            byte lowByte;
            int address;
            if ((address = ByteUtils.getWord(lowByte = data[index++], (byte)((highByte = data[index++]) & 0x3F))) <= 0) continue;
            AddressData addressData = new AddressData(address, AddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
            result.add(addressData);
        }
        return result;
    }
}

