/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;

public class FeedbackCurrentResponse
extends BidibMessage {
    public static final Integer TYPE = 167;

    FeedbackCurrentResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_BM_CURRENT received.");
        }
    }

    public FeedbackCurrentResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_BM_CURRENT received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_CURRENT";
    }

    public int getCurrent() {
        return ConversionUtils.convertCurrent(ByteUtils.getInt(this.getData()[0]));
    }

    public int getLocalDetectorAddress() {
        byte[] data = this.getData();
        return ByteUtils.getInt(data[0]);
    }
}

