/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.PomAddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackCvResponse
extends BidibMessage {
    public static final Integer TYPE = 165;

    FeedbackCvResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 2) {
            throw new ProtocolException("No valid MSG_BM_CV received.");
        }
    }

    public FeedbackCvResponse(byte[] addr, int num, int address, int cvNumber, int dat) throws ProtocolException {
        this(addr, num, 165, FeedbackCvResponse.prepareData(address, cvNumber & 0x3FF, ByteUtils.getLowByte(dat)));
    }

    public FeedbackCvResponse(byte[] addr, int num, int address, int cvNumber, byte dat) throws ProtocolException {
        this(addr, num, 165, FeedbackCvResponse.prepareData(address, cvNumber & 0x3FF, dat));
    }

    public FeedbackCvResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 2) {
            throw new ProtocolException("No valid MSG_BM_CV received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_CV";
    }

    private static byte[] prepareData(int address, int cvNumber, byte data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(address));
        out.write(ByteUtils.getHighByte(address) & 0x3F);
        out.write(ByteUtils.getLowByte(cvNumber));
        out.write(ByteUtils.getHighByte(cvNumber));
        out.write(data);
        return out.toByteArray();
    }

    public PomAddressData getAddress() {
        byte[] data = this.getData();
        int index = 0;
        byte lowByte = data[index++];
        byte highByte = data[index++];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        return new PomAddressData(address, PomAddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
    }

    public int getCvNumber() {
        byte[] data = this.getData();
        int index = 2;
        byte lowByte = data[index++];
        byte highByte = data[index++];
        int cvNumber = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        return ++cvNumber;
    }

    public int getDat() {
        return ByteUtils.getInt(this.getData()[4]);
    }
}

