/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.DccAInfoIndexedString;
import org.bidib.jbidibc.messages.DccAInfoShortGui;
import org.bidib.jbidibc.messages.DccAInfoShortInfo;
import org.bidib.jbidibc.messages.DecoderIdAddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.enums.DccAOpCodeBm;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.FeedbackExtResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackDccAResponse
extends FeedbackExtResponse {
    private static final int DATA_BEGIN_INDEX = 8;
    public static final Integer TYPE = 171;

    FeedbackDccAResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_BM_DCCA received.");
        }
    }

    public FeedbackDccAResponse(byte[] addr, int num, int detectorAddress) throws ProtocolException {
        this(addr, num, 171, ByteUtils.getLowByte(detectorAddress));
    }

    public FeedbackDccAResponse(byte[] addr, int num, int detectorAddress, DccAOpCodeBm opCode, DecoderIdAddressData decoderUniqueData) throws ProtocolException {
        this(addr, num, 171, FeedbackDccAResponse.prepareData(detectorAddress, opCode, decoderUniqueData));
    }

    public FeedbackDccAResponse(byte[] addr, int num, int detectorAddress, DccAOpCodeBm opCode, DecoderUniqueIdData did, int hashValue) throws ProtocolException {
        this(addr, num, 171, FeedbackDccAResponse.prepareData(detectorAddress, opCode, did, hashValue));
    }

    public FeedbackDccAResponse(byte[] addr, int num, int detectorAddress, DccAOpCodeBm opCode, DecoderUniqueIdData did, int index, byte[] data) throws ProtocolException {
        this(addr, num, 171, FeedbackDccAResponse.prepareData(detectorAddress, opCode, did, index, data));
    }

    public FeedbackDccAResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_BM_DCCA received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_DCCA";
    }

    public int getChannel() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public DccAOpCodeBm getOpCode() {
        return DccAOpCodeBm.valueOf(this.getData()[1]);
    }

    private static byte[] prepareData(int detectorAddress, DccAOpCodeBm opCode, DecoderIdAddressData decoderUniqueData) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(detectorAddress));
        out.write(opCode.getType());
        decoderUniqueData.writeToStream(out);
        return out.toByteArray();
    }

    private static byte[] prepareData(int detectorAddress, DccAOpCodeBm opCode, DecoderUniqueIdData did, int hashValue) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(detectorAddress));
        out.write(opCode.getType());
        did.writeToStream(out);
        out.write(ByteUtils.getLowByte(hashValue));
        out.write(ByteUtils.getHighByte(hashValue));
        out.write(ByteUtils.getHighWordLowByte(hashValue));
        out.write(ByteUtils.getHighWordHighByte(hashValue));
        return out.toByteArray();
    }

    private static byte[] prepareData(int detectorAddress, DccAOpCodeBm opCode, DecoderUniqueIdData did, int index, byte[] data) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(detectorAddress));
        out.write(opCode.getType());
        did.writeToStream(out);
        out.write(ByteUtils.getLowByte(index));
        try {
            out.write(data);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public DecoderIdAddressData getDecoderIdAddressData() throws ProtocolException {
        DecoderIdAddressData addressData = null;
        switch (this.getOpCode()) {
            case BIDIB_DCCA_LOGON_NEW_DID: 
            case BIDIB_DCCA_LOGON_ASSIGN_ACK: {
                long mun = ByteUtils.getDWORD(this.getData(), 2);
                int mid = ByteUtils.getInt(this.getData()[6], this.getData()[7]);
                addressData = new DecoderIdAddressData(mun, mid);
                break;
            }
            case BIDIB_DCCA_INFO_SHORTGUI: 
            case BIDIB_DCCA_INFO_SHORTINFO: 
            case BIDIB_DCCA_INFO_PRODUCTNAME: 
            case BIDIB_DCCA_INFO_FULLNAME: 
            case BIDIB_DCCA_INFO_SHORTNAME: 
            case BIDIB_DCCA_INFO_FIRMWAREID: 
            case BIDIB_DCCA_INFO_FUNCMAP: 
            case BIDIB_DCCA_INFO_RAILCOM: 
            case BIDIB_DCCA_INFO_PICTURE: 
            case BIDIB_DCCA_INFO_CV_P0: 
            case BIDIB_DCCA_INFO_CV_P1: {
                long mun = ByteUtils.getDWORD(this.getData(), 2);
                int mid = ByteUtils.getInt(this.getData()[6], this.getData()[7]);
                addressData = new DecoderIdAddressData(mun, mid);
                break;
            }
            default: {
                throw new ProtocolException("The opCode does not match BIDIB_DCCA_LOGON_NEW_DID or BIDIB_DCCA_INFO*: " + this.getOpCode());
            }
        }
        return addressData;
    }

    public Long getAssignHash() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_LOGON_ASSIGN_ACK != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_LOGON_ASSIGN_ACK: " + this.getOpCode());
        }
        Long hash = ByteUtils.getDWORD(this.getData(), 8);
        return hash;
    }

    public DccAInfoShortInfo getShortInfo() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_INFO_SHORTINFO != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_INFO_SHORTINFO: " + this.getOpCode());
        }
        int idx = ByteUtils.getInt(this.getData()[8]);
        byte[] shortInfo = ByteUtils.subArray(this.getData(), 9, 5);
        return new DccAInfoShortInfo(idx, shortInfo);
    }

    public DccAInfoShortGui getShortGui() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_INFO_SHORTGUI != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_INFO_SHORTGUI: " + this.getOpCode());
        }
        int idx = ByteUtils.getInt(this.getData()[8]);
        byte[] shortInfo = ByteUtils.subArray(this.getData(), 9, 5);
        return new DccAInfoShortGui(idx, shortInfo);
    }

    public DccAInfoIndexedString getFirmwareId() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_INFO_FIRMWAREID != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_INFO_FIRMWAREID: " + this.getOpCode());
        }
        int idx = ByteUtils.getInt(this.getData()[8]);
        String firmwareId = FeedbackDccAResponse.formatFirmwareId(idx, this.getData(), 9);
        return new DccAInfoIndexedString(idx, firmwareId);
    }

    public static String formatFirmwareId(int idx, byte[] data, int offset) {
        int len = data.length - offset;
        StringBuilder r = new StringBuilder(len * 2 + 1);
        r.append(idx == 0 ? "P-" : ", V-");
        for (int index = 0; index < len; ++index) {
            byte b = data[index + offset];
            r.append(ByteUtils.HEXARRAY[b >> 4 & 0xF]);
            r.append(ByteUtils.HEXARRAY[b & 0xF]);
            if (index >= len - 1) continue;
            r.append('.');
        }
        return r.substring(0, r.length());
    }

    public DccAInfoIndexedString getShortName() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_INFO_SHORTNAME != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_INFO_SHORTNAME: " + this.getOpCode());
        }
        int idx = ByteUtils.getInt(this.getData()[8]);
        String shortName = ByteUtils.getStringTerminatedbyZero(this.getData(), 9);
        return new DccAInfoIndexedString(idx, shortName);
    }

    public DccAInfoIndexedString getFullName() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_INFO_FULLNAME != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_INFO_FULLNAME: " + this.getOpCode());
        }
        int idx = ByteUtils.getInt(this.getData()[8]);
        String fullName = ByteUtils.getStringTerminatedbyZero(this.getData(), 9);
        return new DccAInfoIndexedString(idx, fullName);
    }

    public DccAInfoIndexedString getProductName() throws ProtocolException {
        if (DccAOpCodeBm.BIDIB_DCCA_INFO_PRODUCTNAME != this.getOpCode()) {
            throw new ProtocolException("The opCode does not match BIDIB_DCCA_INFO_PRODUCTNAME: " + this.getOpCode());
        }
        int idx = ByteUtils.getInt(this.getData()[8]);
        String productName = ByteUtils.getStringTerminatedbyZero(this.getData(), 9);
        return new DccAInfoIndexedString(idx, productName);
    }
}

