/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackDynStateResponse
extends BidibMessage {
    public static final Integer TYPE = 170;

    FeedbackDynStateResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 5) {
            throw new ProtocolException("No valid MSG_BM_DYN_STATE received.");
        }
    }

    public FeedbackDynStateResponse(byte[] addr, int num, int detectorNumber, AddressData addressData, byte dynNumber, byte dynValue) throws ProtocolException {
        this(addr, num, 170, FeedbackDynStateResponse.prepareDynamicStateData(detectorNumber, addressData, dynNumber, dynValue));
    }

    public FeedbackDynStateResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 5) {
            throw new ProtocolException("No valid MSG_BM_DYN_STATE received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_DYN_STATE";
    }

    public int getDetectorNumber() {
        int dectectorNumber = ByteUtils.getInt(this.getData()[0]);
        if (dectectorNumber < 255) {
            return ByteUtils.getInt(dectectorNumber, 127);
        }
        return dectectorNumber;
    }

    private static byte[] prepareDynamicStateData(int detectorNumber, AddressData addressData, byte dynNumber, byte dynValue) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(ByteUtils.getLowByte(detectorNumber));
        addressData.writeToStream(out);
        out.write(dynNumber);
        out.write(dynValue);
        return out.toByteArray();
    }

    public AddressData getAddress() {
        byte[] data = this.getData();
        int index = 1;
        byte lowByte = data[index++];
        byte highByte = data[index];
        int address = ByteUtils.getWord(lowByte, (byte)(highByte & 0x3F));
        return new AddressData(address, AddressTypeEnum.valueOf((byte)((highByte & 0xC0) >> 6)));
    }

    public int getDynNumber() {
        return ByteUtils.getInt(this.getData()[3], 255);
    }

    public int getDynValue() {
        if (this.getDynNumber() == 6 && this.getData().length >= 6) {
            return ByteUtils.getInt(this.getData()[4], this.getData()[5]);
        }
        return ByteUtils.getInt(this.getData()[4], 255);
    }

    public Integer getTimestamp() {
        if (this.getDynNumber() == 6 && this.getData().length >= 8) {
            return ByteUtils.getWORD(this.getData(), 6);
        }
        return null;
    }
}

