/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackExtResponse
extends BidibMessage {
    public static final Integer TYPE = 171;

    FeedbackExtResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_BM_RCPLUS or MSG_BM_DCCA received.");
        }
    }

    public FeedbackExtResponse(byte[] addr, int num, int opCode, int detectorAddress) throws ProtocolException {
        this(addr, num, opCode, ByteUtils.getLowByte(detectorAddress));
    }

    public FeedbackExtResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_BM_RCPLUS or MSG_BM_DCCA received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_EXT";
    }

    public int getDetectorNumber() {
        return this.getData()[0];
    }

    public int getGenericOpCode() {
        return ByteUtils.getInt(this.getData()[1]);
    }
}

