/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibCommandMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackMirrorPositionMessage
extends BidibCommandMessage {
    public FeedbackMirrorPositionMessage(int decoderAddress, int locationType, int locationAddress, byte ... extendedData) throws ProtocolException {
        super(0, 38, new Builder(decoderAddress).addType(locationType).addAddress(locationAddress).addExtendedData(extendedData).build());
    }

    public FeedbackMirrorPositionMessage(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    public String getName() {
        return "MSG_BM_MIRROR_POSITION";
    }

    @Override
    public Integer[] getExpectedResponseTypes() {
        return null;
    }

    private static class Builder {
        private ByteArrayOutputStream stream = new ByteArrayOutputStream(10);

        public Builder(int decoderAddress) throws ProtocolException {
            try {
                this.stream.write(ByteUtils.toWORD(decoderAddress));
            }
            catch (IOException ex) {
                throw new ProtocolException("Add decoder address to stream failed", ex);
            }
        }

        public Builder addType(int type) {
            this.stream.write(ByteUtils.getLowByte(type));
            return this;
        }

        public Builder addAddress(int address) throws ProtocolException {
            try {
                this.stream.write(ByteUtils.toWORD(address));
            }
            catch (IOException ex) {
                throw new ProtocolException("Add address to stream failed", ex);
            }
            return this;
        }

        public Builder addExtendedData(byte[] extendedData) throws ProtocolException {
            if (extendedData != null) {
                try {
                    this.stream.write(extendedData);
                }
                catch (IOException ex) {
                    throw new ProtocolException("Add extendedData to stream failed", ex);
                }
            }
            return this;
        }

        public byte[] build() {
            return this.stream.toByteArray();
        }
    }
}

