/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackMultipleResponse
extends BidibMessage {
    public static final Integer TYPE = 162;

    FeedbackMultipleResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 3) {
            throw new ProtocolException("No valid MSG_BM_MULTIPLE received.");
        }
    }

    public FeedbackMultipleResponse(byte[] addr, int num, byte baseAddress, byte feedbackSize, byte[] feedbackMultiple) throws ProtocolException {
        this(addr, num, 162, ByteUtils.concat(new byte[]{baseAddress, feedbackSize}, feedbackMultiple));
    }

    public FeedbackMultipleResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 3) {
            throw new ProtocolException("No valid MSG_BM_MULTIPLE received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_MULTIPLE";
    }

    public int getBaseAddress() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public byte[] getDetectorData() {
        byte[] data = this.getData();
        byte[] result = new byte[data.length - 2];
        System.arraycopy(data, 2, result, 0, result.length);
        return result;
    }

    public int getSize() {
        return ByteUtils.getInt(this.getData()[1]);
    }
}

