/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackOccupiedResponse
extends BidibMessage {
    public static final Integer TYPE = 160;

    FeedbackOccupiedResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_BM_OCC received.");
        }
    }

    public FeedbackOccupiedResponse(byte[] addr, int num, int detectorAddress) throws ProtocolException {
        this(addr, num, 160, ByteUtils.getLowByte(detectorAddress));
    }

    public FeedbackOccupiedResponse(byte[] addr, int num, int detectorAddress, int timestamp) throws ProtocolException {
        this(addr, num, 160, ByteUtils.getLowByte(detectorAddress), ByteUtils.getLowByte(timestamp), ByteUtils.getHighByte(timestamp));
    }

    public FeedbackOccupiedResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_BM_OCC received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_OCC";
    }

    public int getDetectorNumber() {
        return ByteUtils.getInt(this.getData()[0]);
    }

    public Integer getTimestamp() {
        switch (this.getData().length) {
            case 3: {
                int ts = ByteUtils.getWORD(this.getData(), 1);
                return ts;
            }
        }
        return null;
    }
}

