/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessage;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackPositionResponse
extends BidibMessage {
    public static final Integer TYPE = 172;

    FeedbackPositionResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 5) {
            throw new ProtocolException("No valid MSG_BM_POSITION received.");
        }
    }

    public FeedbackPositionResponse(byte[] addr, int num, int decoderAddress, int locationType, int locationAddress) throws ProtocolException {
        this(addr, num, 172, new Builder(decoderAddress).addType(locationType).addAddress(locationAddress).build());
    }

    public FeedbackPositionResponse(byte[] addr, int num, int decoderAddress, int locationType, int locationAddress, byte[] extendedData) throws ProtocolException {
        this(addr, num, 172, new Builder(decoderAddress).addType(locationType).addAddress(locationAddress).addExtendedData(extendedData).build());
    }

    public FeedbackPositionResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 5) {
            throw new ProtocolException("No valid MSG_BM_POSITION received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_POSITION";
    }

    public int getDecoderAddress() {
        return ByteUtils.getWORD(this.getData(), 0);
    }

    public int getLocationType() {
        return ByteUtils.getInt(this.getData()[2]);
    }

    public PositionLocationEnum getPositionType() {
        return PositionLocationEnum.valueOf(this.getData()[2]);
    }

    public int getLocationAddress() {
        return ByteUtils.getWORD(this.getData(), 3);
    }

    public byte[] getExtendedData() {
        switch (this.getPositionType()) {
            case RFID_READOUT: {
                if (this.getData().length <= 11) break;
                return ByteUtils.subArray(this.getData(), 5, this.getData().length - 5);
            }
            case AXLE_COUNTER: {
                if (this.getData().length <= 5) break;
                return ByteUtils.subArray(this.getData(), 5, this.getData().length - 5);
            }
        }
        return null;
    }

    private static class Builder {
        private ByteArrayOutputStream stream = new ByteArrayOutputStream(10);

        public Builder(int decoderAddress) throws ProtocolException {
            try {
                this.stream.write(ByteUtils.toWORD(decoderAddress));
            }
            catch (IOException ex) {
                throw new ProtocolException("Add decoder address to stream failed", ex);
            }
        }

        public Builder addType(int locationType) {
            this.stream.write(ByteUtils.getLowByte(locationType));
            return this;
        }

        public Builder addAddress(int address) throws ProtocolException {
            try {
                this.stream.write(ByteUtils.toWORD(address));
            }
            catch (IOException ex) {
                throw new ProtocolException("Add address to stream failed", ex);
            }
            return this;
        }

        public Builder addExtendedData(byte[] extendedData) throws ProtocolException {
            if (extendedData != null) {
                try {
                    this.stream.write(extendedData);
                }
                catch (IOException ex) {
                    throw new ProtocolException("Add extendedData to stream failed", ex);
                }
            }
            return this;
        }

        public byte[] build() {
            return this.stream.toByteArray();
        }
    }
}

