/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.messages.message;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.DecoderUniqueIdData;
import org.bidib.jbidibc.messages.RcPlusFeedbackBindData;
import org.bidib.jbidibc.messages.enums.RcPlusOpCodeBm;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.FeedbackExtResponse;
import org.bidib.jbidibc.messages.utils.ByteUtils;

public class FeedbackRcPlusResponse
extends FeedbackExtResponse {
    public static final Integer TYPE = 171;

    FeedbackRcPlusResponse(byte[] addr, int num, int type, byte ... data) throws ProtocolException {
        super(addr, num, type, data);
        if (data == null || data.length < 1) {
            throw new ProtocolException("No valid MSG_BM_RCPLUS received.");
        }
    }

    public FeedbackRcPlusResponse(byte[] addr, int num, int detectorAddress) throws ProtocolException {
        this(addr, num, 171, ByteUtils.getLowByte(detectorAddress));
    }

    public FeedbackRcPlusResponse(byte[] message) throws ProtocolException {
        super(message);
    }

    @Override
    protected void verify() throws ProtocolException {
        if (this.getData() == null || this.getData().length < 1) {
            throw new ProtocolException("No valid MSG_BM_RCPLUS received.");
        }
    }

    @Override
    public String getName() {
        return "MSG_BM_RCPLUS";
    }

    public RcPlusOpCodeBm getOpCode() {
        return RcPlusOpCodeBm.valueOf(this.getData()[1]);
    }

    public DecoderUniqueIdData getRcPlusUniqueId() throws ProtocolException {
        byte[] data = this.getData();
        DecoderUniqueIdData uniqueIdData = null;
        switch (this.getOpCode()) {
            case RC_FIND_COLLISION_P0: 
            case RC_FIND_COLLISION_P1: 
            case RC_PONG_OKAY_LOCO_P0: 
            case RC_PONG_OKAY_LOCO_P1: 
            case RC_PONG_OKAY_ACCESSORY_P0: 
            case RC_PONG_OKAY_ACCESSORY_P1: 
            case RC_PONG_NEW_LOCO_P0: 
            case RC_PONG_NEW_LOCO_P1: 
            case RC_PONG_NEW_ACCESSORY_P0: 
            case RC_PONG_NEW_ACCESSORY_P1: 
            case RC_BIND_ACCEPTED_LOCO: 
            case RC_BIND_ACCEPTED_ACCESSORY: {
                uniqueIdData = DecoderUniqueIdData.fromByteArray(data, 2);
                break;
            }
            default: {
                throw new ProtocolException("The current opCode is not RC_FIND_COLLISION or RC_PONG_OKAY/NEW or BIND_ACCEPTED!");
            }
        }
        return uniqueIdData;
    }

    public AddressData getAddress() throws ProtocolException {
        byte[] data = this.getData();
        AddressData addressData = null;
        switch (this.getOpCode()) {
            case RC_BIND_ACCEPTED_LOCO: 
            case RC_BIND_ACCEPTED_ACCESSORY: {
                addressData = AddressData.fromByteArray(data, 7);
                break;
            }
            default: {
                throw new ProtocolException("The current opCode is not RC_BIND_ACCEPTED!");
            }
        }
        return addressData;
    }

    public RcPlusFeedbackBindData getRcPlusFeedbackBind() throws ProtocolException {
        byte[] data = this.getData();
        RcPlusFeedbackBindData bindData = null;
        switch (this.getOpCode()) {
            case RC_BIND_ACCEPTED_LOCO: 
            case RC_BIND_ACCEPTED_ACCESSORY: {
                bindData = RcPlusFeedbackBindData.fromByteArray(data, 2);
                break;
            }
            default: {
                throw new ProtocolException("The current opCode is not RC_BIND_ACCEPTED!");
            }
        }
        return bindData;
    }
}

